/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.promotion.vo;

import com.biz.base.exception.BizSilentException;
import com.biz.base.exception.ExceptionType;
import com.biz.base.exception.promotion.PromotionExceptionType;
import com.biz.base.exception.utils.AssertUtils;
import com.biz.base.vo.promotion.PromotionProductVo;
import com.biz.model.promotion.enums.PromotionProductLimitTypeEnum;
import com.biz.model.promotion.vo.BasePromotionVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ApiModel(value="\u7528\u6237\u9996\u5355\u7acb\u51cf\u6d3b\u52a8Vo")
public class UserFirstOrderCutPromotionVo
extends BasePromotionVo {
    private static final long serialVersionUID = 7141174857527011461L;
    @ApiModelProperty(value="\u4e0d\u80fd\u53c2\u4e0e\u9996\u5355\u7acb\u51cf\u6d3b\u52a8\u7684\u5546\u54c1\u96c6\u5408")
    private List<PromotionProductVo> excludeProducts;
    @ApiModelProperty(value="\u9650\u5236\u4e0d\u80fd\u53c2\u4e0e\u4fc3\u9500\u6d3b\u52a8\u7c7b\u578b")
    private PromotionProductLimitTypeEnum excludeType = PromotionProductLimitTypeEnum.LIMIT_BY_PRODUCT;
    @ApiModelProperty(value="\u4fc3\u9500\u751f\u6548\u5546\u54c1\u91d1\u989d\u9650\u5236")
    private String productAmountLimit;
    @ApiModelProperty(value="\u51cf\u514d\u91d1\u989d")
    private String cutAmount;

    public List<Long> getExcludeProductIds() {
        return Optional.ofNullable(this.excludeProducts).orElse(Lists.newArrayList()).stream().map(PromotionProductVo::getProductId).map(Long::valueOf).collect(Collectors.toList());
    }

    public List<String> getExcludeProductCodes() {
        return Optional.ofNullable(this.excludeProducts).orElse(Lists.newArrayList()).stream().map(PromotionProductVo::getProductCode).collect(Collectors.toList());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    @Override
    public void validate() {
        super.validate();
        try {
            Integer productAmountLimitInt = Integer.valueOf(this.productAmountLimit);
            Integer cutAmountInt = Integer.valueOf(this.cutAmount);
            AssertUtils.isTrue((productAmountLimitInt > 0 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4fc3\u9500\u751f\u6548\u9650\u5236\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((cutAmountInt > 0 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4fc3\u9500\u51cf\u514d\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((productAmountLimitInt >= cutAmountInt ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4fc3\u9500\u51cf\u514d\u91d1\u989d\u4e0d\u80fd\u6bd4\u95e8\u69db\u91d1\u989d\u5927");
        }
        catch (NumberFormatException e) {
            throw new BizSilentException("\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57\u7c7b\u578b");
        }
    }

    public List<PromotionProductVo> getExcludeProducts() {
        return this.excludeProducts;
    }

    public PromotionProductLimitTypeEnum getExcludeType() {
        return this.excludeType;
    }

    public String getProductAmountLimit() {
        return this.productAmountLimit;
    }

    public String getCutAmount() {
        return this.cutAmount;
    }

    public void setExcludeProducts(List<PromotionProductVo> excludeProducts) {
        this.excludeProducts = excludeProducts;
    }

    public void setExcludeType(PromotionProductLimitTypeEnum excludeType) {
        this.excludeType = excludeType;
    }

    public void setProductAmountLimit(String productAmountLimit) {
        this.productAmountLimit = productAmountLimit;
    }

    public void setCutAmount(String cutAmount) {
        this.cutAmount = cutAmount;
    }
}

