/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.promotion.vo;

import com.biz.base.enums.CommonStatus;
import com.biz.base.exception.ExceptionType;
import com.biz.base.exception.promotion.PromotionExceptionType;
import com.biz.base.exception.utils.AssertUtils;
import com.biz.base.interfaces.IModelValidation;
import com.biz.primus.common.support.jackson.PrimusLocalDateTimeDeserializer;
import com.biz.primus.common.support.jackson.PrimusLocalDateTimeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ApiModel(value="\u6d3b\u52a8\u8be6\u60c5Vo")
public class ActivityVo
implements Serializable,
IModelValidation {
    private static final long serialVersionUID = 4530476977380496375L;
    @ApiModelProperty(value="\u6d3b\u52a8ID")
    private String id;
    @ApiModelProperty(value="\u6d3b\u52a8\u540d\u79f0")
    private String name;
    @ApiModelProperty(value="\u6d3b\u52a8\u63cf\u8ff0")
    private String description;
    @ApiModelProperty(value="\u6d3b\u52a8\u56fe\u7247")
    private String logo;
    @JsonSerialize(using=PrimusLocalDateTimeSerializer.class)
    @JsonDeserialize(using=PrimusLocalDateTimeDeserializer.class)
    @ApiModelProperty(value="\u5f00\u59cb\u65f6\u95f4")
    private transient LocalDateTime startTime;
    @JsonSerialize(using=PrimusLocalDateTimeSerializer.class)
    @JsonDeserialize(using=PrimusLocalDateTimeDeserializer.class)
    @ApiModelProperty(value="\u7ed3\u675f\u65f6\u95f4")
    private transient LocalDateTime endTime;
    @ApiModelProperty(value="\u662f\u5426\u5e94\u7528\u4e8e\u9996\u9875")
    private Boolean apply4HomePage = false;
    @ApiModelProperty(value="\u6d3b\u52a8\u5bcc\u6587\u672c")
    private String rawHtml;
    @ApiModelProperty(value="\u542f\u7528\u72b6\u6001")
    private CommonStatus status = CommonStatus.DISABLE;

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public void validate() {
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.name), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e13\u9898\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((this.name.length() <= 20 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e13\u9898\u6d3b\u52a8\u9875\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.logo), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e13\u9898\u6d3b\u52a8\u9875Logo\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)this.startTime, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e13\u9898\u6d3b\u52a8\u9875\u7684\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)this.endTime, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e13\u9898\u6d3b\u52a8\u9875\u7684\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)this.startTime.isBefore(this.endTime), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e13\u9898\u6d3b\u52a8\u9875\u7684\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u6bd4\u7ed3\u675f\u65f6\u95f4\u665a");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.rawHtml), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e13\u9898\u6d3b\u52a8\u9875\u5bcc\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLogo() {
        return this.logo;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public Boolean getApply4HomePage() {
        return this.apply4HomePage;
    }

    public String getRawHtml() {
        return this.rawHtml;
    }

    public CommonStatus getStatus() {
        return this.status;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public void setApply4HomePage(Boolean apply4HomePage) {
        this.apply4HomePage = apply4HomePage;
    }

    public void setRawHtml(String rawHtml) {
        this.rawHtml = rawHtml;
    }

    public void setStatus(CommonStatus status) {
        this.status = status;
    }
}

