/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.promotion.vo;

import com.biz.base.enums.CommonStatus;
import com.biz.base.enums.promotion.PromotionScopeEnum;
import com.biz.base.exception.ExceptionType;
import com.biz.base.exception.promotion.PromotionExceptionType;
import com.biz.base.exception.utils.AssertUtils;
import com.biz.base.interfaces.IModelValidation;
import com.biz.base.vo.IPromotionScope;
import com.biz.model.promotion.enums.PromotionProductLimitTypeEnum;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BasePromotionVo
implements Serializable,
IModelValidation,
IPromotionScope {
    private static final long serialVersionUID = -3854840004048369519L;
    private String id;
    private String name;
    private String description;
    private List<String> channels;
    private String startTime;
    private String endTime;
    private List<Long> effectMemberLevels;
    private List<Long> effectMemberTags;
    private PromotionScopeEnum scope;
    private List<String> scopeIds;
    private List<String> scopeProvinceIds;
    private List<String> scopeCityIds;
    private List<String> scopeZoneIds;
    private List<String> scopeShopIds;
    private String overlayPromotionIds;
    private PromotionProductLimitTypeEnum productLimitType;
    private String limitCategoryIds;
    private String limitBrandIds;
    private List<String> limitProductIds;
    private List<String> limitProductCodes;
    private Boolean allowCoupon = false;
    private CommonStatus commonStatus = CommonStatus.ENABLE;
    private Boolean userOnceGainLimit = false;
    private Timestamp createTimestamp;
    private String promotionStatus;
    private String productJson;
    private String couponJson;

    public void validate() {
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getName()), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"[\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a]");
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(this.channels), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"[\u6d3b\u52a8\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a]");
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(this.effectMemberLevels), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"[\u6d3b\u52a8\u751f\u6548\u7684\u4f1a\u5458\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a]");
        AssertUtils.isTrue((StringUtils.isNotBlank((CharSequence)this.startTime) && StringUtils.isNotBlank((CharSequence)this.endTime) ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"[\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a]");
        LocalDateTime startTime = LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").parse(this.startTime));
        LocalDateTime endTime = LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").parse(this.endTime));
        AssertUtils.isTrue((boolean)startTime.isBefore(endTime), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"[\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u9700\u8981\u6bd4\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u65e9]");
    }

    public List<Long> scopeProvinceIds() {
        return Optional.ofNullable(this.getScopeProvinceIds()).orElse(Lists.newArrayList()).stream().map(id -> Long.valueOf(StringUtils.trim((String)id))).collect(Collectors.toList());
    }

    public List<Long> scopeCityIds() {
        return Optional.ofNullable(this.getScopeCityIds()).orElse(Lists.newArrayList()).stream().map(id -> Long.valueOf(StringUtils.trim((String)id))).collect(Collectors.toList());
    }

    public List<Long> scopeZoneIds() {
        return Optional.ofNullable(this.getScopeZoneIds()).orElse(Lists.newArrayList()).stream().map(id -> Long.valueOf(StringUtils.trim((String)id))).collect(Collectors.toList());
    }

    public List<Long> scopeShopIds() {
        return Optional.ofNullable(this.getScopeShopIds()).orElse(Lists.newArrayList()).stream().map(id -> Long.valueOf(StringUtils.trim((String)id))).collect(Collectors.toList());
    }

    public Long promotionId() {
        return StringUtils.isBlank((CharSequence)this.getId()) ? null : Long.valueOf(this.getId());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getChannels() {
        return this.channels;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public List<Long> getEffectMemberLevels() {
        return this.effectMemberLevels;
    }

    public List<Long> getEffectMemberTags() {
        return this.effectMemberTags;
    }

    public PromotionScopeEnum getScope() {
        return this.scope;
    }

    public List<String> getScopeIds() {
        return this.scopeIds;
    }

    public List<String> getScopeProvinceIds() {
        return this.scopeProvinceIds;
    }

    public List<String> getScopeCityIds() {
        return this.scopeCityIds;
    }

    public List<String> getScopeZoneIds() {
        return this.scopeZoneIds;
    }

    public List<String> getScopeShopIds() {
        return this.scopeShopIds;
    }

    public String getOverlayPromotionIds() {
        return this.overlayPromotionIds;
    }

    public PromotionProductLimitTypeEnum getProductLimitType() {
        return this.productLimitType;
    }

    public String getLimitCategoryIds() {
        return this.limitCategoryIds;
    }

    public String getLimitBrandIds() {
        return this.limitBrandIds;
    }

    public List<String> getLimitProductIds() {
        return this.limitProductIds;
    }

    public List<String> getLimitProductCodes() {
        return this.limitProductCodes;
    }

    public Boolean getAllowCoupon() {
        return this.allowCoupon;
    }

    public CommonStatus getCommonStatus() {
        return this.commonStatus;
    }

    public Boolean getUserOnceGainLimit() {
        return this.userOnceGainLimit;
    }

    public Timestamp getCreateTimestamp() {
        return this.createTimestamp;
    }

    public String getPromotionStatus() {
        return this.promotionStatus;
    }

    public String getProductJson() {
        return this.productJson;
    }

    public String getCouponJson() {
        return this.couponJson;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setChannels(List<String> channels) {
        this.channels = channels;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setEffectMemberLevels(List<Long> effectMemberLevels) {
        this.effectMemberLevels = effectMemberLevels;
    }

    public void setEffectMemberTags(List<Long> effectMemberTags) {
        this.effectMemberTags = effectMemberTags;
    }

    public void setScope(PromotionScopeEnum scope) {
        this.scope = scope;
    }

    public void setScopeIds(List<String> scopeIds) {
        this.scopeIds = scopeIds;
    }

    public void setScopeProvinceIds(List<String> scopeProvinceIds) {
        this.scopeProvinceIds = scopeProvinceIds;
    }

    public void setScopeCityIds(List<String> scopeCityIds) {
        this.scopeCityIds = scopeCityIds;
    }

    public void setScopeZoneIds(List<String> scopeZoneIds) {
        this.scopeZoneIds = scopeZoneIds;
    }

    public void setScopeShopIds(List<String> scopeShopIds) {
        this.scopeShopIds = scopeShopIds;
    }

    public void setOverlayPromotionIds(String overlayPromotionIds) {
        this.overlayPromotionIds = overlayPromotionIds;
    }

    public void setProductLimitType(PromotionProductLimitTypeEnum productLimitType) {
        this.productLimitType = productLimitType;
    }

    public void setLimitCategoryIds(String limitCategoryIds) {
        this.limitCategoryIds = limitCategoryIds;
    }

    public void setLimitBrandIds(String limitBrandIds) {
        this.limitBrandIds = limitBrandIds;
    }

    public void setLimitProductIds(List<String> limitProductIds) {
        this.limitProductIds = limitProductIds;
    }

    public void setLimitProductCodes(List<String> limitProductCodes) {
        this.limitProductCodes = limitProductCodes;
    }

    public void setAllowCoupon(Boolean allowCoupon) {
        this.allowCoupon = allowCoupon;
    }

    public void setCommonStatus(CommonStatus commonStatus) {
        this.commonStatus = commonStatus;
    }

    public void setUserOnceGainLimit(Boolean userOnceGainLimit) {
        this.userOnceGainLimit = userOnceGainLimit;
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public void setPromotionStatus(String promotionStatus) {
        this.promotionStatus = promotionStatus;
    }

    public void setProductJson(String productJson) {
        this.productJson = productJson;
    }

    public void setCouponJson(String couponJson) {
        this.couponJson = couponJson;
    }
}

