/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.promotion.vo;

import com.biz.base.exception.ExceptionType;
import com.biz.base.exception.promotion.PromotionExceptionType;
import com.biz.base.exception.utils.AssertUtils;
import com.biz.model.promotion.vo.BasePromotionVo;
import com.biz.model.promotion.vo.CutPriceSalePromotionItemVo;
import com.biz.model.promotion.vo.CutPriceStairVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ApiModel(value="\u964d\u4ef7\u62cd\u4fc3\u9500Vo")
public class CutPriceSalePromotionVo
extends BasePromotionVo {
    private static final long serialVersionUID = -5674504281086648065L;
    @ApiModelProperty(value="\u964d\u4ef7\u89c4\u5219")
    private List<CutPriceStairVo> rules;
    @ApiModelProperty(value="\u964d\u4ef7\u89c4\u5219")
    private List<CutPriceSalePromotionItemVo> promotionItems;

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    @Override
    public void validate() {
        super.validate();
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(this.rules), (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u964d\u4ef7\u62cd\u6d3b\u52a8\u964d\u4ef7\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        this.rules.forEach(CutPriceStairVo::validate);
        Collections.sort(this.rules);
        for (int i = 0; i < this.rules.size() - 1; ++i) {
            CutPriceStairVo stair1 = this.rules.get(i);
            CutPriceStairVo stair2 = this.rules.get(i + 1);
            AssertUtils.isTrue((boolean)stair1.getEndTime().isBefore(stair2.getStartTime()), (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u964d\u4ef7\u62cd\u65f6\u95f4\u6bb5\u6709\u91cd\u53e0");
        }
        Optional.ofNullable(this.promotionItems).orElse(Lists.newArrayList()).forEach(CutPriceSalePromotionItemVo::validate);
    }

    public List<CutPriceStairVo> getRules() {
        return this.rules;
    }

    public List<CutPriceSalePromotionItemVo> getPromotionItems() {
        return this.promotionItems;
    }

    public void setRules(List<CutPriceStairVo> rules) {
        this.rules = rules;
    }

    public void setPromotionItems(List<CutPriceSalePromotionItemVo> promotionItems) {
        this.promotionItems = promotionItems;
    }
}

