/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.promotion.vo;

import com.biz.base.exception.BizSilentException;
import com.biz.base.exception.ExceptionType;
import com.biz.base.exception.promotion.PromotionExceptionType;
import com.biz.base.exception.utils.AssertUtils;
import com.biz.base.interfaces.IModelValidation;
import com.biz.primus.common.support.jackson.PrimusLocalTimeDeserializer;
import com.biz.primus.common.support.jackson.PrimusLocalTimeSerializer;
import com.biz.primus.common.utils.ValueUtils;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.time.LocalTime;
import java.util.Objects;

public class CutPriceStairVo
implements Serializable,
IModelValidation,
Comparable<CutPriceStairVo> {
    private static final long serialVersionUID = 6222615695299527153L;
    @JsonSerialize(using=PrimusLocalTimeSerializer.class)
    @JsonDeserialize(using=PrimusLocalTimeDeserializer.class)
    private transient LocalTime startTime;
    @JsonSerialize(using=PrimusLocalTimeSerializer.class)
    @JsonDeserialize(using=PrimusLocalTimeDeserializer.class)
    private transient LocalTime endTime;
    private Integer salePrice;

    public Boolean isNowInPromotionTimeRange() {
        AssertUtils.isTrue((Objects.nonNull(this.endTime) && Objects.nonNull(this.startTime) && Objects.nonNull(this.salePrice) ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_STATE);
        LocalTime now = LocalTime.now();
        if (this.startTime == null) {
            throw new BizSilentException((ExceptionType)PromotionExceptionType.ILLEGAL_STATE);
        }
        if (this.endTime == null) {
            throw new BizSilentException((ExceptionType)PromotionExceptionType.ILLEGAL_STATE);
        }
        return this.startTime.isBefore(now) && this.endTime.isAfter(now);
    }

    public void validate() {
        AssertUtils.notNull((Object)this.startTime, (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u964d\u4ef7\u62cd\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)this.endTime, (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u964d\u4ef7\u62cd\u89c4\u5219\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)this.startTime.isBefore(this.endTime), (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u964d\u4ef7\u62cd\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u8981\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4");
        AssertUtils.isTrue((ValueUtils.getValue((Integer)this.salePrice) > 0 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u964d\u4ef7\u62cd\u4fc3\u9500\u89c4\u5219\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0");
    }

    @Override
    public int compareTo(CutPriceStairVo o) {
        return this.startTime.compareTo(o.getStartTime());
    }

    public boolean equals(Object obj) {
        if (obj instanceof CutPriceStairVo) {
            CutPriceStairVo vo = (CutPriceStairVo)obj;
            return this == vo;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode();
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public Integer getSalePrice() {
        return this.salePrice;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public void setSalePrice(Integer salePrice) {
        this.salePrice = salePrice;
    }
}

