/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.promotion.vo;

import com.biz.base.exception.ExceptionType;
import com.biz.base.exception.promotion.PromotionExceptionType;
import com.biz.base.exception.utils.AssertUtils;
import com.biz.base.vo.promotion.PromotionCouponVo;
import com.biz.base.vo.promotion.PromotionGiftTypeEnum;
import com.biz.model.promotion.enums.PromotionPointGiftTypeEnum;
import com.biz.model.promotion.enums.PromotionTargetLimitTypeEnum;
import com.biz.model.promotion.vo.BasePromotionVo;
import com.biz.primus.common.utils.ValueUtils;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ApiModel(value="\u4e70\u8d60\u6ee1\u8d60\u6d3b\u52a8Vo")
public class PurchaseGiftPromotionVo
extends BasePromotionVo {
    private static final long serialVersionUID = -3897654093446967521L;
    @ApiModelProperty(value="\u4fc3\u9500\u65b9\u5f0f\u679a\u4e3e(\u6309\u7167\u5546\u54c1\u91d1\u989d/\u5546\u54c1\u6570\u91cf)")
    private PromotionTargetLimitTypeEnum limitType;
    @ApiModelProperty(value="\u9650\u5236\u91d1\u989d")
    private Integer limitAmount;
    @ApiModelProperty(value="\u9650\u5236\u6570\u91cf")
    private Integer limitQuantity;
    @ApiModelProperty(value="\u8d60\u54c1\u7c7b\u578b")
    private PromotionGiftTypeEnum giftType;
    @ApiModelProperty(value="\u8d60\u9001\u5546\u54c1\u6570\u91cf")
    private Integer giftProductQuantity;
    @ApiModelProperty(value="\u8d60\u54c1ID\u96c6\u5408")
    private List<Long> giftProductIds;
    @ApiModelProperty(value="\u8d60\u54c1\u7f16\u7801\u96c6\u5408")
    private List<String> giftProductCodes;
    @ApiModelProperty(value="\u662f\u5426\u9650\u5236\u8d60\u9001\u5546\u54c1\u7684\u5e93\u5b58")
    private Boolean limitGiftProductStock;
    @ApiModelProperty(value="\u8d60\u9001\u79ef\u5206\u7c7b\u578b(\u6309\u7167\u6570\u91cf\u589e\u957f/\u6309\u7167\u500d\u6570\u589e\u957f)")
    private PromotionPointGiftTypeEnum pointGiftType;
    @ApiModelProperty(value="\u8d60\u9001\u79ef\u5206\u6570\u91cf")
    private Integer pointQuantity;
    @ApiModelProperty(value="\u79ef\u5206\u589e\u957f\u500d\u6570")
    private Integer pointIncreaseTimes;
    @ApiModelProperty(value="\u8d60\u9001\u5238\u96c6\u5408")
    private List<PromotionCouponVo> coupons;

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    @Override
    public void validate() {
        super.validate();
        AssertUtils.notNull((Object)((Object)this.limitType), (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u4fc3\u9500\u6761\u4ef6\u9650\u5236\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.limitType == PromotionTargetLimitTypeEnum.DISCOUNT_BY_PRODUCT_AMOUNT) {
            AssertUtils.isTrue((ValueUtils.getValue((Integer)this.limitAmount) > 0 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u4fc3\u9500\u9650\u5236\u5546\u54c1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            AssertUtils.isTrue((ValueUtils.getValue((Integer)this.limitQuantity) > 0 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u4fc3\u9500\u9650\u5236\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AssertUtils.notNull((Object)this.giftType, (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u4fc3\u9500\u8d60\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.giftType == PromotionGiftTypeEnum.MEMBER_POINT) {
            AssertUtils.notNull((Object)((Object)this.pointGiftType), (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u7528\u6237\u79ef\u5206\u589e\u957f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            if (this.pointGiftType == PromotionPointGiftTypeEnum.BY_QUANTITY) {
                AssertUtils.isTrue((ValueUtils.getValue((Integer)this.pointQuantity) > 0 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u8d60\u9001\u79ef\u5206\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                AssertUtils.isTrue((ValueUtils.getValue((Integer)this.pointIncreaseTimes) > 0 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u8d60\u9001\u79ef\u5206\u589e\u957f\u500d\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (this.giftType == PromotionGiftTypeEnum.COUPON) {
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(this.coupons), (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u8d60\u9001\u4f18\u60e0\u5238\u4e0d\u80fd\u4e3a\u7a7a");
            HashSet couponIds = Sets.newHashSet();
            this.coupons.forEach(promotionCouponVo -> {
                promotionCouponVo.validate();
                couponIds.add(promotionCouponVo.getId());
            });
            AssertUtils.isTrue((couponIds.size() == this.coupons.size() ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_STATE, (String)"\u8d60\u9001\u7684\u4f18\u60e0\u5238\u4e0d\u80fd\u91cd\u590d");
        } else {
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(this.giftProductIds), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u8d60\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((ValueUtils.getValue((Integer)this.giftProductQuantity) > 0 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u8d60\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        }
    }

    public PromotionTargetLimitTypeEnum getLimitType() {
        return this.limitType;
    }

    public Integer getLimitAmount() {
        return this.limitAmount;
    }

    public Integer getLimitQuantity() {
        return this.limitQuantity;
    }

    public PromotionGiftTypeEnum getGiftType() {
        return this.giftType;
    }

    public Integer getGiftProductQuantity() {
        return this.giftProductQuantity;
    }

    public List<Long> getGiftProductIds() {
        return this.giftProductIds;
    }

    public List<String> getGiftProductCodes() {
        return this.giftProductCodes;
    }

    public Boolean getLimitGiftProductStock() {
        return this.limitGiftProductStock;
    }

    public PromotionPointGiftTypeEnum getPointGiftType() {
        return this.pointGiftType;
    }

    public Integer getPointQuantity() {
        return this.pointQuantity;
    }

    public Integer getPointIncreaseTimes() {
        return this.pointIncreaseTimes;
    }

    public List<PromotionCouponVo> getCoupons() {
        return this.coupons;
    }

    public void setLimitType(PromotionTargetLimitTypeEnum limitType) {
        this.limitType = limitType;
    }

    public void setLimitAmount(Integer limitAmount) {
        this.limitAmount = limitAmount;
    }

    public void setLimitQuantity(Integer limitQuantity) {
        this.limitQuantity = limitQuantity;
    }

    public void setGiftType(PromotionGiftTypeEnum giftType) {
        this.giftType = giftType;
    }

    public void setGiftProductQuantity(Integer giftProductQuantity) {
        this.giftProductQuantity = giftProductQuantity;
    }

    public void setGiftProductIds(List<Long> giftProductIds) {
        this.giftProductIds = giftProductIds;
    }

    public void setGiftProductCodes(List<String> giftProductCodes) {
        this.giftProductCodes = giftProductCodes;
    }

    public void setLimitGiftProductStock(Boolean limitGiftProductStock) {
        this.limitGiftProductStock = limitGiftProductStock;
    }

    public void setPointGiftType(PromotionPointGiftTypeEnum pointGiftType) {
        this.pointGiftType = pointGiftType;
    }

    public void setPointQuantity(Integer pointQuantity) {
        this.pointQuantity = pointQuantity;
    }

    public void setPointIncreaseTimes(Integer pointIncreaseTimes) {
        this.pointIncreaseTimes = pointIncreaseTimes;
    }

    public void setCoupons(List<PromotionCouponVo> coupons) {
        this.coupons = coupons;
    }
}

