/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.promotion.vo.req;

import com.biz.base.enums.order.OrderTypeEnum;
import com.biz.model.payment.enums.PaymentType;
import com.biz.model.promotion.vo.IModelPostConstructProcessor;
import com.biz.model.promotion.vo.req.BaseProductPromotionReqVo;
import com.biz.model.promotion.vo.req.OrderPromotionReqItemVo;
import com.biz.primus.common.utils.ValueUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class OrderPromotionReqDetailVo
extends BaseProductPromotionReqVo
implements IModelPostConstructProcessor,
Serializable {
    private static final long serialVersionUID = -2095219627716429365L;
    @ApiModelProperty(value="\u53c2\u6570\u6807\u8bc6(\u9700\u8981\u4f20\u5165\u552f\u4e00\u7684\u6807\u8bc6\u7b26, \u5efa\u8baeUUID)", required=true)
    private String paramSeq;
    @ApiModelProperty(value="\u5f53\u5929\u7b2cx\u5355", required=true)
    private Integer dayOrderNo;
    @ApiModelProperty(value="\u4e0b\u5355\u6709\u793c\u6d3b\u52a8\u65f6\u95f4\u8303\u56f4\u5185\u7b2cx\u5355")
    private Integer luckyOrderTimePeriodNo;
    @ApiModelProperty(value="\u8ba2\u5355\u7c7b\u578b", allowableValues="O2O/MALL", required=true)
    private OrderTypeEnum orderType;
    @ApiModelProperty(value="\u652f\u4ed8\u65b9\u5f0f", required=true)
    private PaymentType paymentType;
    @ApiModelProperty(value="\u8ba2\u5355\u5546\u54c1\u9879\u660e\u7ec6", required=true)
    private List<OrderPromotionReqItemVo> items;
    @ApiModelProperty(hidden=true)
    @JsonIgnore
    private List<Long> requestProductIds;
    @ApiModelProperty(hidden=true)
    @JsonIgnore
    private Set<Long> requestCategoryIds;
    @ApiModelProperty(hidden=true)
    @JsonIgnore
    private Set<Long> requestBrandIds;
    @ApiModelProperty(hidden=true)
    @JsonIgnore
    private Map<Long, Integer> requestProductQuantities;
    @ApiModelProperty(hidden=true)
    @JsonIgnore
    private Map<Long, Long> requestProductAmount;
    @ApiModelProperty(hidden=true)
    @JsonIgnore
    private Map<Long, Long> requestCategoryAmount;
    @ApiModelProperty(hidden=true)
    @JsonIgnore
    private Map<Long, Long> requestBrandAmount;
    @ApiModelProperty(hidden=true)
    @JsonIgnore
    private Map<Long, List<Long>> requestCategoryProductIds;
    @ApiModelProperty(hidden=true)
    @JsonIgnore
    private Map<Long, List<Long>> requestBrandProductIds;
    @JsonIgnore
    private boolean hasBeenPostProcessed = false;
    @JsonIgnore
    private Long totalAmount;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    @Override
    public void postProcess() {
        if (this.hasBeenPostProcessed) {
            return;
        }
        this.totalAmount = 0L;
        if (CollectionUtils.isNotEmpty(this.items)) {
            if (Objects.isNull(this.requestProductIds)) {
                this.requestProductIds = Lists.newArrayList();
            } else if (CollectionUtils.isNotEmpty(this.requestProductIds)) {
                this.requestProductIds.clear();
            }
            if (Objects.isNull(this.requestProductQuantities)) {
                this.requestProductQuantities = Maps.newHashMap();
            } else if (MapUtils.isNotEmpty(this.requestProductQuantities)) {
                this.requestProductQuantities.clear();
            }
            if (Objects.isNull(this.requestCategoryAmount)) {
                this.requestCategoryAmount = Maps.newHashMap();
            } else if (MapUtils.isNotEmpty(this.requestCategoryAmount)) {
                this.requestCategoryAmount.clear();
            }
            if (Objects.isNull(this.requestBrandAmount)) {
                this.requestBrandAmount = Maps.newHashMap();
            } else if (MapUtils.isNotEmpty(this.requestBrandAmount)) {
                this.requestBrandAmount = Maps.newHashMap();
            }
            if (Objects.isNull(this.requestProductAmount)) {
                this.requestProductAmount = Maps.newHashMap();
            } else if (MapUtils.isNotEmpty(this.requestProductAmount)) {
                this.requestProductAmount.clear();
            }
            if (Objects.isNull(this.requestCategoryIds)) {
                this.requestCategoryIds = Sets.newHashSet();
            } else if (CollectionUtils.isNotEmpty(this.requestCategoryIds)) {
                this.requestCategoryIds.clear();
            }
            if (Objects.isNull(this.requestBrandIds)) {
                this.requestBrandIds = Sets.newHashSet();
            } else if (CollectionUtils.isNotEmpty(this.requestBrandIds)) {
                this.requestBrandIds.clear();
            }
            if (Objects.isNull(this.requestCategoryProductIds)) {
                this.requestCategoryProductIds = Maps.newHashMap();
            } else if (MapUtils.isNotEmpty(this.requestCategoryProductIds)) {
                this.requestCategoryProductIds.clear();
            }
            if (Objects.isNull(this.requestBrandProductIds)) {
                this.requestBrandProductIds = Maps.newHashMap();
            } else if (MapUtils.isNotEmpty(this.requestBrandProductIds)) {
                this.requestBrandProductIds.clear();
            }
            this.items.forEach(vo -> {
                Long productAmount = vo.getProductAmount(this.paymentType);
                this.requestProductIds.add(vo.getProductId());
                this.requestProductQuantities.put(vo.getProductId(), vo.getFinalQuantity());
                this.requestProductAmount.put(vo.getProductId(), productAmount);
                this.totalAmount = this.totalAmount + productAmount;
                if (Objects.nonNull(vo.getCategoryId())) {
                    this.requestCategoryIds.add(vo.getCategoryId());
                    Long categoryAmount = this.requestCategoryAmount.getOrDefault(vo.getCategoryId(), 0L);
                    categoryAmount = categoryAmount + productAmount;
                    this.requestCategoryAmount.put(vo.getCategoryId(), categoryAmount);
                    List<Long> categoryProductIds = this.requestCategoryProductIds.getOrDefault(vo.getCategoryId(), Lists.newArrayList());
                    categoryProductIds.add(vo.getProductId());
                    this.requestCategoryProductIds.put(vo.getCategoryId(), categoryProductIds);
                }
                if (Objects.nonNull(vo.getBrandId())) {
                    this.requestBrandIds.add(vo.getBrandId());
                    Long brandAmount = this.requestBrandAmount.getOrDefault(vo.getBrandId(), 0L);
                    brandAmount = brandAmount + productAmount;
                    this.requestBrandAmount.put(vo.getBrandId(), brandAmount);
                    List<Long> brandProductIds = this.requestBrandProductIds.getOrDefault(vo.getBrandId(), Lists.newArrayList());
                    brandProductIds.add(vo.getProductId());
                    this.requestBrandProductIds.put(vo.getBrandId(), brandProductIds);
                }
            });
            this.hasBeenPostProcessed = true;
        }
    }

    @Override
    public boolean hasBeenPostProcessed() {
        return this.hasBeenPostProcessed;
    }

    public Long getProductAmount(Long productId) {
        return this.requestProductAmount.getOrDefault(productId, 0L);
    }

    public Long getCategoryAmount(Long categoryId) {
        return this.requestCategoryAmount.getOrDefault(categoryId, 0L);
    }

    public Long getBrandAmount(Long brandId) {
        return this.requestBrandAmount.getOrDefault(brandId, 0L);
    }

    public Long getTotalAmount() {
        return ValueUtils.getValue((Long)this.totalAmount);
    }

    public List<Long> getRequestProductIds() {
        return Optional.ofNullable(this.requestProductIds).orElse(Lists.newArrayList());
    }

    public List<Long> getRequestCategoryProductIds(Long categoryId) {
        return Objects.isNull(categoryId) ? Lists.newArrayList() : this.requestCategoryProductIds.getOrDefault(categoryId, Lists.newArrayList());
    }

    public List<Long> getRequestBrandProductIds(Long brandId) {
        return Objects.isNull(brandId) ? Lists.newArrayList() : this.requestBrandProductIds.getOrDefault(brandId, Lists.newArrayList());
    }

    public Integer getRequestProductQuantity(Long productId) {
        return this.requestProductQuantities.getOrDefault(productId, 0);
    }

    public String getParamSeq() {
        return this.paramSeq;
    }

    public Integer getDayOrderNo() {
        return this.dayOrderNo;
    }

    public Integer getLuckyOrderTimePeriodNo() {
        return this.luckyOrderTimePeriodNo;
    }

    public OrderTypeEnum getOrderType() {
        return this.orderType;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public List<OrderPromotionReqItemVo> getItems() {
        return this.items;
    }

    public Set<Long> getRequestCategoryIds() {
        return this.requestCategoryIds;
    }

    public Set<Long> getRequestBrandIds() {
        return this.requestBrandIds;
    }

    public Map<Long, Integer> getRequestProductQuantities() {
        return this.requestProductQuantities;
    }

    public Map<Long, Long> getRequestProductAmount() {
        return this.requestProductAmount;
    }

    public Map<Long, Long> getRequestCategoryAmount() {
        return this.requestCategoryAmount;
    }

    public Map<Long, Long> getRequestBrandAmount() {
        return this.requestBrandAmount;
    }

    public Map<Long, List<Long>> getRequestCategoryProductIds() {
        return this.requestCategoryProductIds;
    }

    public Map<Long, List<Long>> getRequestBrandProductIds() {
        return this.requestBrandProductIds;
    }

    public boolean isHasBeenPostProcessed() {
        return this.hasBeenPostProcessed;
    }

    public void setParamSeq(String paramSeq) {
        this.paramSeq = paramSeq;
    }

    public void setDayOrderNo(Integer dayOrderNo) {
        this.dayOrderNo = dayOrderNo;
    }

    public void setLuckyOrderTimePeriodNo(Integer luckyOrderTimePeriodNo) {
        this.luckyOrderTimePeriodNo = luckyOrderTimePeriodNo;
    }

    public void setOrderType(OrderTypeEnum orderType) {
        this.orderType = orderType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public void setItems(List<OrderPromotionReqItemVo> items) {
        this.items = items;
    }

    public void setRequestProductIds(List<Long> requestProductIds) {
        this.requestProductIds = requestProductIds;
    }

    public void setRequestCategoryIds(Set<Long> requestCategoryIds) {
        this.requestCategoryIds = requestCategoryIds;
    }

    public void setRequestBrandIds(Set<Long> requestBrandIds) {
        this.requestBrandIds = requestBrandIds;
    }

    public void setRequestProductQuantities(Map<Long, Integer> requestProductQuantities) {
        this.requestProductQuantities = requestProductQuantities;
    }

    public void setRequestProductAmount(Map<Long, Long> requestProductAmount) {
        this.requestProductAmount = requestProductAmount;
    }

    public void setRequestCategoryAmount(Map<Long, Long> requestCategoryAmount) {
        this.requestCategoryAmount = requestCategoryAmount;
    }

    public void setRequestBrandAmount(Map<Long, Long> requestBrandAmount) {
        this.requestBrandAmount = requestBrandAmount;
    }

    public void setRequestCategoryProductIds(Map<Long, List<Long>> requestCategoryProductIds) {
        this.requestCategoryProductIds = requestCategoryProductIds;
    }

    public void setRequestBrandProductIds(Map<Long, List<Long>> requestBrandProductIds) {
        this.requestBrandProductIds = requestBrandProductIds;
    }

    public void setHasBeenPostProcessed(boolean hasBeenPostProcessed) {
        this.hasBeenPostProcessed = hasBeenPostProcessed;
    }

    public void setTotalAmount(Long totalAmount) {
        this.totalAmount = totalAmount;
    }
}

