/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;
import javax.persistence.AttributeConverter;

public enum PullOrderTypeEnum implements BaseEnum
{
    NORMAL(10, "\u666e\u901a\u8ba2\u5355"),
    AFTER_SALE(20, "\u552e\u540e\u8ba2\u5355");

    private int code;
    private String description;
    private static final PullOrderTypeEnum[] PULL_ORDER_TYPE_ENUMS;

    private PullOrderTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static PullOrderTypeEnum getByCode(Integer code) {
        for (PullOrderTypeEnum pullOrderTypeEnum : PULL_ORDER_TYPE_ENUMS) {
            if (!Objects.equals(pullOrderTypeEnum.code, code)) continue;
            return pullOrderTypeEnum;
        }
        return null;
    }

    public static PullOrderTypeEnum getByDescription(String description) {
        for (PullOrderTypeEnum pullOrderTypeEnum : PULL_ORDER_TYPE_ENUMS) {
            if (!Objects.equals(pullOrderTypeEnum.getDescription(), description)) continue;
            return pullOrderTypeEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (PullOrderTypeEnum pullOrderTypeEnum : PULL_ORDER_TYPE_ENUMS) {
            result += pullOrderTypeEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return PULL_ORDER_TYPE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        PULL_ORDER_TYPE_ENUMS = PullOrderTypeEnum.values();
    }

    public static class Converter
    implements AttributeConverter<PullOrderTypeEnum, Integer> {
        public Integer convertToDatabaseColumn(PullOrderTypeEnum attribute) {
            return attribute.code;
        }

        public PullOrderTypeEnum convertToEntityAttribute(Integer dbData) {
            return PullOrderTypeEnum.getByCode(dbData);
        }
    }
}

