/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;
import javax.persistence.AttributeConverter;

public enum StatusEnum implements BaseEnum
{
    ENABLE(1, "\u6b63\u5e38\u4f7f\u7528"),
    DISABLE(-1, "\u5df2\u88ab\u51bb\u7ed3");

    private int code;
    private String description;
    private static final StatusEnum[] STATUS_ENUMS;

    private StatusEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static StatusEnum getByCode(Integer code) {
        for (StatusEnum statusEnum : STATUS_ENUMS) {
            if (!Objects.equals(statusEnum.code, code)) continue;
            return statusEnum;
        }
        return null;
    }

    public static StatusEnum getByDescription(String description) {
        for (StatusEnum statusEnum : STATUS_ENUMS) {
            if (!Objects.equals(statusEnum.getDescription(), description)) continue;
            return statusEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (StatusEnum statusEnum : STATUS_ENUMS) {
            result += statusEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return STATUS_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        STATUS_ENUMS = StatusEnum.values();
    }

    public static class Converter
    implements AttributeConverter<StatusEnum, Integer> {
        public Integer convertToDatabaseColumn(StatusEnum attribute) {
            return attribute.code;
        }

        public StatusEnum convertToEntityAttribute(Integer dbData) {
            return StatusEnum.getByCode(dbData);
        }
    }
}

