/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant;

import com.biz.pull.orders.constant.BaseEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public enum SystemParamsEnum implements BaseEnum
{
    TIME_INTERVAL(10, "timeInterval"),
    EXCLUDE_TIME(20, "excludeTime");

    private int code;
    private String description;
    private static final SystemParamsEnum[] SYSTEM_PARAMS_ENUMS;

    private SystemParamsEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static SystemParamsEnum getByCode(Integer code) {
        for (SystemParamsEnum systemParamsEnum : SYSTEM_PARAMS_ENUMS) {
            if (!Objects.equals(systemParamsEnum.code, code)) continue;
            return systemParamsEnum;
        }
        return null;
    }

    public static SystemParamsEnum getByDescription(String description) {
        for (SystemParamsEnum systemParamsEnum : SYSTEM_PARAMS_ENUMS) {
            if (!Objects.equals(systemParamsEnum.getDescription(), description)) continue;
            return systemParamsEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (SystemParamsEnum systemParamsEnum : SYSTEM_PARAMS_ENUMS) {
            result += systemParamsEnum.getCode();
        }
        return result;
    }

    public static List<String> getAllDescription() {
        ArrayList result = Lists.newArrayList();
        for (SystemParamsEnum systemParamsEnum : SYSTEM_PARAMS_ENUMS) {
            result.add(systemParamsEnum.getDescription());
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return SYSTEM_PARAMS_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        SYSTEM_PARAMS_ENUMS = SystemParamsEnum.values();
    }
}

