/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum ChargeTypeEnum implements BaseEnum
{
    PLATFORM(10, "\u5e73\u53f0\u9500\u552e\u62bd\u6210"),
    COUPON(20, "\u4f18\u60e0\u5238");

    private int code;
    private String description;
    private static final ChargeTypeEnum[] CHARGE_TYPE_ENUMS;

    private ChargeTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static ChargeTypeEnum getByCode(Integer code) {
        for (ChargeTypeEnum chargeTypeEnum : CHARGE_TYPE_ENUMS) {
            if (!Objects.equals(chargeTypeEnum.code, code)) continue;
            return chargeTypeEnum;
        }
        return null;
    }

    public static ChargeTypeEnum getByDescription(String description) {
        for (ChargeTypeEnum chargeTypeEnum : CHARGE_TYPE_ENUMS) {
            if (!Objects.equals(chargeTypeEnum.getDescription(), description)) continue;
            return chargeTypeEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (ChargeTypeEnum chargeTypeEnum : CHARGE_TYPE_ENUMS) {
            result += chargeTypeEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return CHARGE_TYPE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        CHARGE_TYPE_ENUMS = ChargeTypeEnum.values();
    }
}

