/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum CouponTypeEnum implements BaseEnum
{
    PLATFORM(10, "\u5e73\u53f0"),
    VENDER(20, "\u5546\u5bb6");

    private int code;
    private String description;
    private static final CouponTypeEnum[] COUPON_TYPE_ENUMS;

    private CouponTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static CouponTypeEnum getByCode(Integer code) {
        for (CouponTypeEnum couponTypeEnum : COUPON_TYPE_ENUMS) {
            if (!Objects.equals(couponTypeEnum.code, code)) continue;
            return couponTypeEnum;
        }
        return null;
    }

    public static CouponTypeEnum getByDescription(String description) {
        for (CouponTypeEnum couponTypeEnum : COUPON_TYPE_ENUMS) {
            if (!Objects.equals(couponTypeEnum.getDescription(), description)) continue;
            return couponTypeEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (CouponTypeEnum couponTypeEnum : COUPON_TYPE_ENUMS) {
            result += couponTypeEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return COUPON_TYPE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        COUPON_TYPE_ENUMS = CouponTypeEnum.values();
    }
}

