/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum DeliveryTypeEnum implements BaseEnum
{
    ONLY_WORK_DAY(10, "\u53ea\u5de5\u4f5c\u65e5"),
    ONLY_HOLIDAY(20, "\u53ea\u53cc\u4f11\u65e5\u3001\u8282\u5047\u65e5"),
    ANY_TIME(30, "\u4efb\u610f\u65f6\u95f4");

    private int code;
    private String description;
    private static final DeliveryTypeEnum[] DELIVERY_TYPE_ENUMS;

    private DeliveryTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static DeliveryTypeEnum getByCode(Integer code) {
        for (DeliveryTypeEnum deliveryTypeEnum : DELIVERY_TYPE_ENUMS) {
            if (!Objects.equals(deliveryTypeEnum.code, code)) continue;
            return deliveryTypeEnum;
        }
        return null;
    }

    public static DeliveryTypeEnum getByDescription(String description) {
        for (DeliveryTypeEnum deliveryTypeEnum : DELIVERY_TYPE_ENUMS) {
            if (!Objects.equals(deliveryTypeEnum.getDescription(), description)) continue;
            return deliveryTypeEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (DeliveryTypeEnum deliveryTypeEnum : DELIVERY_TYPE_ENUMS) {
            result += deliveryTypeEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return DELIVERY_TYPE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        DELIVERY_TYPE_ENUMS = DeliveryTypeEnum.values();
    }
}

