/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum InvoiceTypeEnum implements BaseEnum
{
    ORDINARY_PAPER_INVOICE(10, "\u666e\u901a\u7eb8\u8d28\u53d1\u7968"),
    ELECTRONIC_INVOICE(20, "\u7535\u5b50\u53d1\u7968"),
    VAT_TICKET(30, "\u589e\u503c\u7a0e\u53d1\u7968");

    private int code;
    private String description;
    private static final InvoiceTypeEnum[] INVOICE_TYPE_ENUMS;

    private InvoiceTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static InvoiceTypeEnum getByCode(Integer code) {
        for (InvoiceTypeEnum invoiceTypeEnum : INVOICE_TYPE_ENUMS) {
            if (!Objects.equals(invoiceTypeEnum.code, code)) continue;
            return invoiceTypeEnum;
        }
        return null;
    }

    public static InvoiceTypeEnum getByDescription(String description) {
        for (InvoiceTypeEnum invoiceTypeEnum : INVOICE_TYPE_ENUMS) {
            if (!Objects.equals(invoiceTypeEnum.getDescription(), description)) continue;
            return invoiceTypeEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (InvoiceTypeEnum invoiceTypeEnum : INVOICE_TYPE_ENUMS) {
            result += invoiceTypeEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return INVOICE_TYPE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        INVOICE_TYPE_ENUMS = InvoiceTypeEnum.values();
    }
}

