/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum OrderStateEnum implements BaseEnum
{
    WAIT_PAID(10, "\u5f85\u652f\u4ed8"),
    PAY_INFO_CONFIRM(11, "\u4ed8\u6b3e\u4fe1\u606f\u786e\u8ba4\u4e2d"),
    WAIT_AUDITED(20, "\u5f85\u5ba1\u6838"),
    WAIT_DISTRIBUTION(30, "\u5f85\u914d\u8d27"),
    WAIT_DELIVERY_GOODS(40, "\u5f85\u53d1\u8d27"),
    IN_TRANSIT(50, "\u8fd0\u8f93\u4e2d"),
    BE_DELIVERED(60, "\u5df2\u9001\u8fbe"),
    TRADE_SUCCESS(70, "\u4ea4\u6613\u6210\u529f"),
    TRADE_FAIL(-10, "\u4ea4\u6613\u5931\u8d25"),
    CANCEL(-100, "\u53d6\u6d88\u4e2d"),
    REFUND(-200, "\u9000\u6b3e\u4e2d"),
    CLOSED(-500, "\u4ea4\u6613\u5173\u95ed");

    private int code;
    private String description;
    private static final OrderStateEnum[] ORDER_STATE_ENUMS;

    private OrderStateEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static OrderStateEnum getByCode(Integer code) {
        for (OrderStateEnum orderStateEnum : ORDER_STATE_ENUMS) {
            if (!Objects.equals(orderStateEnum.code, code)) continue;
            return orderStateEnum;
        }
        return null;
    }

    public static OrderStateEnum getByDescription(String description) {
        for (OrderStateEnum orderStateEnum : ORDER_STATE_ENUMS) {
            if (!Objects.equals(orderStateEnum.getDescription(), description)) continue;
            return orderStateEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (OrderStateEnum orderStateEnum : ORDER_STATE_ENUMS) {
            result += orderStateEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return ORDER_STATE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        ORDER_STATE_ENUMS = OrderStateEnum.values();
    }
}

