/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum OrderTypeEnum implements BaseEnum
{
    SELF_DISTRIBUTE(10, "\u5546\u5bb6\u81ea\u914d\u9001"),
    AGENT_DISTRIBUTE(20, "\u5e73\u53f0\u4ee3\u914d\u9001");

    private int code;
    private String description;
    private static final OrderTypeEnum[] ORDER_TYPE_ENUMS;

    private OrderTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static OrderTypeEnum getByCode(Integer code) {
        for (OrderTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            if (!Objects.equals(orderTypeEnum.code, code)) continue;
            return orderTypeEnum;
        }
        return null;
    }

    public static OrderTypeEnum getByDescription(String description) {
        for (OrderTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            if (!Objects.equals(orderTypeEnum.getDescription(), description)) continue;
            return orderTypeEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (OrderTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            result += orderTypeEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return ORDER_TYPE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        ORDER_TYPE_ENUMS = OrderTypeEnum.values();
    }
}

