/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum PayTypeEnum implements BaseEnum
{
    COD(10, "\u8d27\u5230\u4ed8\u6b3e"),
    POST_OFFICE_REMITTANCE(20, "\u90ae\u5c40\u6c47\u6b3e"),
    SELF_PICK_UP(30, "\u81ea\u63d0"),
    ONLINE_PAY(40, "\u5728\u7ebf\u652f\u4ed8"),
    COMPANY_TRANSFER(50, "\u516c\u53f8\u8f6c\u8d26"),
    BANK_CARD_TRANSFER(60, "\u94f6\u884c\u5361\u8f6c\u8d26"),
    PAID_BY_OTHER_PERSON(70, "\u4ee3\u4ed8");

    private int code;
    private String description;
    private static final PayTypeEnum[] PAY_TYPE_ENUMS;

    private PayTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static PayTypeEnum getByCode(Integer code) {
        for (PayTypeEnum payTypeEnum : PAY_TYPE_ENUMS) {
            if (!Objects.equals(payTypeEnum.code, code)) continue;
            return payTypeEnum;
        }
        return null;
    }

    public static PayTypeEnum getByDescription(String description) {
        for (PayTypeEnum payTypeEnum : PAY_TYPE_ENUMS) {
            if (!Objects.equals(payTypeEnum.getDescription(), description)) continue;
            return payTypeEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (PayTypeEnum payTypeEnum : PAY_TYPE_ENUMS) {
            result += payTypeEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return PAY_TYPE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        PAY_TYPE_ENUMS = PayTypeEnum.values();
    }
}

