/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum PrescriptionTypeEnum implements BaseEnum
{
    COMMON_PRESCRIPTION(10, "\u666e\u901a"),
    TOP_SPEED_PRESCRIPTION(20, "\u6781\u901f\u8fbe"),
    NEXT_DAY_PRESCRIPTION(30, "\u6b21\u65e5\u8fbe"),
    CUSTOMER_PRESCRIPTION(40, "\u81ea\u5b9a\u4e49\u65f6\u95f4");

    private int code;
    private String description;
    private static final PrescriptionTypeEnum[] ORDER_TYPE_ENUMS;

    private PrescriptionTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static PrescriptionTypeEnum getByCode(Integer code) {
        for (PrescriptionTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            if (!Objects.equals(orderTypeEnum.code, code)) continue;
            return orderTypeEnum;
        }
        return null;
    }

    public static PrescriptionTypeEnum getByDescription(String description) {
        for (PrescriptionTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            if (!Objects.equals(orderTypeEnum.getDescription(), description)) continue;
            return orderTypeEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (PrescriptionTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            result += orderTypeEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return ORDER_TYPE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        ORDER_TYPE_ENUMS = PrescriptionTypeEnum.values();
    }
}

