/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum ProductTypeEnum implements BaseEnum
{
    PRODUCT(10, "\u5546\u54c1"),
    GIFT(20, "\u8d60\u54c1");

    private int code;
    private String description;
    private static final ProductTypeEnum[] ORDER_TYPE_ENUMS;

    private ProductTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static ProductTypeEnum getByCode(Integer code) {
        for (ProductTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            if (!Objects.equals(orderTypeEnum.code, code)) continue;
            return orderTypeEnum;
        }
        return null;
    }

    public static ProductTypeEnum getByDescription(String description) {
        for (ProductTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            if (!Objects.equals(orderTypeEnum.getDescription(), description)) continue;
            return orderTypeEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (ProductTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            result += orderTypeEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return ORDER_TYPE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        ORDER_TYPE_ENUMS = ProductTypeEnum.values();
    }
}

