/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum PromoTypeEnum implements BaseEnum
{
    ORDER_LEVEL(10, "\u8ba2\u5355\u7ea7\u522b\u4fc3\u9500"),
    PAY_PLATFORM_LEVEL(20, "\u652f\u4ed8\u5e73\u53f0\u4fc3\u9500"),
    TERMINAL_LEVEL(30, "\u7aef\u4fc3\u9500");

    private int code;
    private String description;
    private static final PromoTypeEnum[] PAY_TYPE_ENUMS;

    private PromoTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static PromoTypeEnum getByCode(Integer code) {
        for (PromoTypeEnum payTypeEnum : PAY_TYPE_ENUMS) {
            if (!Objects.equals(payTypeEnum.code, code)) continue;
            return payTypeEnum;
        }
        return null;
    }

    public static PromoTypeEnum getByDescription(String description) {
        for (PromoTypeEnum payTypeEnum : PAY_TYPE_ENUMS) {
            if (!Objects.equals(payTypeEnum.getDescription(), description)) continue;
            return payTypeEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (PromoTypeEnum payTypeEnum : PAY_TYPE_ENUMS) {
            result += payTypeEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return PAY_TYPE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        PAY_TYPE_ENUMS = PromoTypeEnum.values();
    }
}

