/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum RoleEnum implements BaseEnum
{
    CUSTOMER(10, "\u987e\u5ba2"),
    VENDER(20, "\u5546\u5bb6"),
    PLATFORM(30, "\u5e73\u53f0"),
    SYSTEM(40, "\u7cfb\u7edf");

    private int code;
    private String description;
    private static final RoleEnum[] ROLE_ENUMS;

    private RoleEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static RoleEnum getByCode(Integer code) {
        for (RoleEnum roleEnum : ROLE_ENUMS) {
            if (!Objects.equals(roleEnum.code, code)) continue;
            return roleEnum;
        }
        return null;
    }

    public static RoleEnum getByDescription(String description) {
        for (RoleEnum roleEnum : ROLE_ENUMS) {
            if (!Objects.equals(roleEnum.getDescription(), description)) continue;
            return roleEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (RoleEnum roleEnum : ROLE_ENUMS) {
            result += roleEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return ROLE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        ROLE_ENUMS = RoleEnum.values();
    }
}

