/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum SaleTypeEnum implements BaseEnum
{
    COMMON_SALE(10, "\u5e38\u89c4\u7279\u5356"),
    BRAND_SALE(20, "\u54c1\u724c\u7279\u5356");

    private int code;
    private String description;
    private static final SaleTypeEnum[] ORDER_TYPE_ENUMS;

    private SaleTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static SaleTypeEnum getByCode(Integer code) {
        for (SaleTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            if (!Objects.equals(orderTypeEnum.code, code)) continue;
            return orderTypeEnum;
        }
        return null;
    }

    public static SaleTypeEnum getByDescription(String description) {
        for (SaleTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            if (!Objects.equals(orderTypeEnum.getDescription(), description)) continue;
            return orderTypeEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (SaleTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            result += orderTypeEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return ORDER_TYPE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        ORDER_TYPE_ENUMS = SaleTypeEnum.values();
    }
}

