/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.constant.api;

import com.biz.pull.orders.constant.BaseEnum;
import java.util.Objects;

public enum ShippingTypeEnum implements BaseEnum
{
    EXPRESS(10, "\u5feb\u9012"),
    STORE_PICK_UP(20, "\u5230\u5e97\u81ea\u63d0"),
    SAME_CITY_DISTRIBUTION(30, "\u540c\u57ce\u914d\u9001");

    private int code;
    private String description;
    private static final ShippingTypeEnum[] ORDER_TYPE_ENUMS;

    private ShippingTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static ShippingTypeEnum getByCode(Integer code) {
        for (ShippingTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            if (!Objects.equals(orderTypeEnum.code, code)) continue;
            return orderTypeEnum;
        }
        return null;
    }

    public static ShippingTypeEnum getByDescription(String description) {
        for (ShippingTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            if (!Objects.equals(orderTypeEnum.getDescription(), description)) continue;
            return orderTypeEnum;
        }
        return null;
    }

    public static int getRepresentAllCode() {
        int result = 0;
        for (ShippingTypeEnum orderTypeEnum : ORDER_TYPE_ENUMS) {
            result += orderTypeEnum.getCode();
        }
        return result;
    }

    @Override
    public BaseEnum[] getAllEnums() {
        return ORDER_TYPE_ENUMS;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        ORDER_TYPE_ENUMS = ShippingTypeEnum.values();
    }
}

