/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.util;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final int POOL_CONCURRENT_MAX_TOTAL = 100;
    private static final int SINGLE_ROUTE_CONCURRENT_MAX_TOTAL = 20;
    private static final int MAX_ROUTE_TOTAL = 50;
    private static final int CONNECT_TIME_OUT = 30000;
    private static final int CONNECT_REQUEST_TIME_OUT = 1000;
    private static final int SOCKET_TIME_OUT = 30000;
    private static final String ACCEPT_ENCODING_GZIP_IDENTIFICATION = "gzip";
    private static final String ACCEPT_ENCODING_DEFLATE_IDENTIFICATION = "deflate";
    private static final int HTTP_OK = 200;
    private static final String RESPONSE_ENCODING = "UTF-8";
    private static RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(1000).setSocketTimeout(30000).build();

    private HttpClientUtils() {
    }

    public static List<String> getResponseResult(URI uri, HttpMethod httpMethod, Encoding encoding, Map<String, String> headerParams, Map<String, String> requestParams, int retryNum) {
        CloseableHttpResponse closeableHttpResponse = HttpClientUtils.getResponse(uri, httpMethod, encoding, headerParams, requestParams, retryNum, null);
        return HttpClientUtils.getResponseResult(closeableHttpResponse, encoding);
    }

    public static List<String> getResponseResult(URI uri, HttpMethod httpMethod, Encoding encoding, Map<String, String> headerParams, Map<String, String> requestParams, int retryNum, RequestConfig requestConfig) {
        CloseableHttpResponse closeableHttpResponse = HttpClientUtils.getResponse(uri, httpMethod, encoding, headerParams, requestParams, retryNum, requestConfig);
        return HttpClientUtils.getResponseResult(closeableHttpResponse, encoding);
    }

    public static List<String> getResponseResult(URI uri, Encoding encoding, Map<String, String> headerParams, String requestParams, int retryNum) {
        CloseableHttpResponse closeableHttpResponse = HttpClientUtils.getResponse(uri, encoding, headerParams, requestParams, retryNum, null);
        return HttpClientUtils.getResponseResult(closeableHttpResponse, encoding);
    }

    public static List<String> getResponseResult(URI uri, Encoding encoding, Map<String, String> headerParams, String requestParams, int retryNum, RequestConfig requestConfig) {
        CloseableHttpResponse closeableHttpResponse = HttpClientUtils.getResponse(uri, encoding, headerParams, requestParams, retryNum, requestConfig);
        return HttpClientUtils.getResponseResult(closeableHttpResponse, encoding);
    }

    public static List<String> getResponseResult(URI uri, Encoding encoding, Map<String, String> headerParams, Map<String, String> requestParams, InputStream inputStream, String fileName, String boundary, int retryNum) {
        CloseableHttpResponse closeableHttpResponse = HttpClientUtils.getResponse(uri, encoding, headerParams, requestParams, inputStream, fileName, boundary, retryNum, null);
        return HttpClientUtils.getResponseResult(closeableHttpResponse, encoding);
    }

    public static List<String> getResponseResult(URI uri, Encoding encoding, Map<String, String> headerParams, Map<String, String> requestParams, InputStream inputStream, String fileName, String boundary, int retryNum, RequestConfig requestConfig) {
        CloseableHttpResponse closeableHttpResponse = HttpClientUtils.getResponse(uri, encoding, headerParams, requestParams, inputStream, fileName, boundary, retryNum, requestConfig);
        return HttpClientUtils.getResponseResult(closeableHttpResponse, encoding);
    }

    public static String getStringResponseResult(URI uri, HttpMethod httpMethod, Encoding encoding, Map<String, String> headerParams, Map<String, String> requestParams, int retryNum) {
        StringBuilder sb = new StringBuilder();
        List<String> responseResult = HttpClientUtils.getResponseResult(uri, httpMethod, encoding, headerParams, requestParams, retryNum, null);
        if (CollectionUtils.isNotEmpty(responseResult)) {
            for (String content : responseResult) {
                sb.append(content);
            }
        }
        return sb.toString();
    }

    public static String getStringResponseResult(URI uri, HttpMethod httpMethod, Encoding encoding, Map<String, String> headerParams, Map<String, String> requestParams, int retryNum, RequestConfig requestConfig) {
        StringBuilder sb = new StringBuilder();
        List<String> responseResult = HttpClientUtils.getResponseResult(uri, httpMethod, encoding, headerParams, requestParams, retryNum, requestConfig);
        if (CollectionUtils.isNotEmpty(responseResult)) {
            for (String content : responseResult) {
                sb.append(content);
            }
        }
        return sb.toString();
    }

    public static String getStringResponseResult(URI uri, Encoding encoding, Map<String, String> headerParams, String requestParams, int retryNum) {
        StringBuilder sb = new StringBuilder();
        List<String> responseResult = HttpClientUtils.getResponseResult(uri, encoding, headerParams, requestParams, retryNum, null);
        if (CollectionUtils.isNotEmpty(responseResult)) {
            for (String content : responseResult) {
                sb.append(content);
            }
        }
        return sb.toString();
    }

    public static String getStringResponseResult(URI uri, Encoding encoding, Map<String, String> headerParams, String requestParams, int retryNum, RequestConfig requestConfig) {
        StringBuilder sb = new StringBuilder();
        List<String> responseResult = HttpClientUtils.getResponseResult(uri, encoding, headerParams, requestParams, retryNum, requestConfig);
        if (CollectionUtils.isNotEmpty(responseResult)) {
            for (String content : responseResult) {
                sb.append(content);
            }
        }
        return sb.toString();
    }

    public static String getStringResponseResult(URI uri, Encoding encoding, Map<String, String> headerParams, Map<String, String> requestParams, InputStream fileInputStream, String fileName, String boundary, int retryNum) {
        StringBuilder sb = new StringBuilder();
        List<String> responseResult = HttpClientUtils.getResponseResult(uri, encoding, headerParams, requestParams, fileInputStream, fileName, boundary, retryNum, null);
        if (CollectionUtils.isNotEmpty(responseResult)) {
            for (String content : responseResult) {
                sb.append(content);
            }
        }
        return sb.toString();
    }

    public static String getStringResponseResult(URI uri, Encoding encoding, Map<String, String> headerParams, Map<String, String> requestParams, InputStream fileInputStream, String fileName, String boundary, int retryNum, RequestConfig requestConfig) {
        StringBuilder sb = new StringBuilder();
        List<String> responseResult = HttpClientUtils.getResponseResult(uri, encoding, headerParams, requestParams, fileInputStream, fileName, boundary, retryNum, requestConfig);
        if (CollectionUtils.isNotEmpty(responseResult)) {
            for (String content : responseResult) {
                sb.append(content);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResponseResult(CloseableHttpResponse closeableHttpResponse, Encoding encoding) {
        ArrayList result;
        block11: {
            result = Lists.newArrayList();
            if (null != closeableHttpResponse && closeableHttpResponse.getStatusLine().getStatusCode() == 200 && null != encoding) {
                InputStream inputStream = null;
                BufferedReader br = null;
                try {
                    String content;
                    HttpEntity closeableHttpResponseEntity = closeableHttpResponse.getEntity();
                    Header contentEncoding = closeableHttpResponseEntity.getContentEncoding();
                    if (null != contentEncoding) {
                        if (ACCEPT_ENCODING_GZIP_IDENTIFICATION.equalsIgnoreCase(contentEncoding.getValue())) {
                            closeableHttpResponseEntity = new GzipDecompressingEntity(closeableHttpResponseEntity);
                        } else if (ACCEPT_ENCODING_DEFLATE_IDENTIFICATION.equalsIgnoreCase(contentEncoding.getValue())) {
                            closeableHttpResponseEntity = new DeflateDecompressingEntity(closeableHttpResponseEntity);
                        }
                    }
                    inputStream = closeableHttpResponseEntity.getContent();
                    br = new BufferedReader(new InputStreamReader(inputStream, encoding.getDescription()));
                    while (null != (content = br.readLine())) {
                        result.add(new String(content.getBytes(RESPONSE_ENCODING), RESPONSE_ENCODING));
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
                catch (IOException e) {
                    log.error("\u83b7\u53d6HTTP\u8fde\u63a5\u8fd4\u56de\u503c error:", (Throwable)e);
                    break block11;
                }
                finally {
                    IOUtils.closeQuietly(inputStream);
                    IOUtils.closeQuietly(br);
                }
                IOUtils.closeQuietly((Reader)br);
            }
        }
        return result;
    }

    public static CloseableHttpResponse getResponse(URI uri, HttpMethod httpMethod, Encoding encoding, Map<String, String> headerParams, Map<String, String> requestParams, int retryNum) {
        return HttpClientUtils.getResponse(uri, httpMethod, encoding, headerParams, requestParams, retryNum, null);
    }

    public static CloseableHttpResponse getResponse(URI uri, HttpMethod httpMethod, Encoding encoding, Map<String, String> headerParams, Map<String, String> requestParams, int retryNum, RequestConfig requestConfig) {
        boolean paramIsValid;
        boolean bl = paramIsValid = null != uri && null != httpMethod;
        if (!paramIsValid) {
            return null;
        }
        boolean isGetMethod = httpMethod == HttpMethod.GET;
        String url = uri.toString();
        String contentType = String.format("application/x-www-form-urlencoded; charset=%s", encoding.getDescription());
        String accept = String.format("text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8;charset=%s", encoding.getDescription());
        try {
            HttpGet httpRequestBase;
            Object object = httpRequestBase = isGetMethod ? new HttpGet(url) : new HttpPost(url);
            if (MapUtils.isNotEmpty(requestParams)) {
                ArrayList nameValuePairList = Lists.newArrayList();
                for (Map.Entry<String, String> entry : requestParams.entrySet()) {
                    nameValuePairList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                UrlEncodedFormEntity requestBody = new UrlEncodedFormEntity((List)nameValuePairList, encoding.getDescription());
                if (isGetMethod) {
                    url = String.format("%s?%s", url, EntityUtils.toString((HttpEntity)requestBody));
                    httpRequestBase = new HttpGet(url);
                } else {
                    ((HttpPost)httpRequestBase).setEntity((HttpEntity)requestBody);
                }
            }
            requestConfig = null == requestConfig ? defaultRequestConfig : requestConfig;
            httpRequestBase.setConfig(requestConfig);
            httpRequestBase.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0");
            httpRequestBase.addHeader("Connection", "keep-alive");
            httpRequestBase.addHeader("Accept", accept);
            httpRequestBase.addHeader("Accept-Charset", encoding.getDescription());
            httpRequestBase.addHeader("Content-type", contentType);
            if (MapUtils.isNotEmpty(headerParams)) {
                for (Map.Entry<String, String> entry : headerParams.entrySet()) {
                    httpRequestBase.addHeader(entry.getKey(), entry.getValue());
                }
            }
            return HttpClientUtils.getCachingClient(uri.getHost(), uri.getPort(), retryNum, requestConfig).execute((HttpUriRequest)httpRequestBase, (HttpContext)HttpClientContext.create());
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6HTTP\u8fde\u63a5\u8fd4\u56de\u5b9e\u4f8b error", (Throwable)e);
            return null;
        }
    }

    public static CloseableHttpResponse getResponse(URI uri, Encoding encoding, Map<String, String> headerParams, String requestParams, int retryNum) {
        return HttpClientUtils.getResponse(uri, encoding, headerParams, requestParams, retryNum, null);
    }

    public static CloseableHttpResponse getResponse(URI uri, Encoding encoding, Map<String, String> headerParams, String requestParams, int retryNum, RequestConfig requestConfig) {
        boolean paramIsValid;
        boolean bl = paramIsValid = null != uri && StringUtils.isNotBlank((CharSequence)requestParams);
        if (!paramIsValid) {
            return null;
        }
        String url = uri.toString();
        String contentType = String.format("application/json; charset=%s", encoding.getDescription());
        String accept = String.format("text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8;charset=%s", encoding.getDescription());
        try {
            HttpPost httpRequestBase = new HttpPost(url);
            StringEntity entity = new StringEntity(requestParams, Charset.forName(encoding.getDescription()));
            httpRequestBase.setEntity((HttpEntity)entity);
            requestConfig = null == requestConfig ? defaultRequestConfig : requestConfig;
            httpRequestBase.setConfig(requestConfig);
            httpRequestBase.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0");
            httpRequestBase.addHeader("Connection", "keep-alive");
            httpRequestBase.addHeader("Content-type", contentType);
            httpRequestBase.addHeader("Accept", accept);
            httpRequestBase.addHeader("Accept-Charset", encoding.getDescription());
            if (MapUtils.isNotEmpty(headerParams)) {
                for (Map.Entry<String, String> entry : headerParams.entrySet()) {
                    httpRequestBase.addHeader(entry.getKey(), entry.getValue());
                }
            }
            return HttpClientUtils.getCachingClient(uri.getHost(), uri.getPort(), retryNum, requestConfig).execute((HttpUriRequest)httpRequestBase, (HttpContext)HttpClientContext.create());
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6HTTP\u8fde\u63a5\u8fd4\u56de\u5b9e\u4f8b error:", (Throwable)e);
            return null;
        }
    }

    public static CloseableHttpResponse getResponse(URI uri, Encoding encoding, Map<String, String> headerParams, Map<String, String> requestParams, InputStream inputStream, String fileName, String boundary, int retryNum) {
        return HttpClientUtils.getResponse(uri, encoding, headerParams, requestParams, inputStream, fileName, boundary, retryNum, null);
    }

    public static CloseableHttpResponse getResponse(URI uri, Encoding encoding, Map<String, String> headerParams, Map<String, String> requestParams, InputStream inputStream, String fileName, String boundary, int retryNum, RequestConfig requestConfig) {
        boolean paramIsValid;
        boolean bl = paramIsValid = null != uri && null != inputStream && StringUtils.isNotBlank((CharSequence)fileName);
        if (!paramIsValid) {
            return null;
        }
        String url = uri.toString();
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            HttpPost httpRequestBase = new HttpPost(url);
            if (MapUtils.isNotEmpty(requestParams)) {
                for (Map.Entry<String, String> entry : requestParams.entrySet()) {
                    builder.addTextBody(entry.getKey(), entry.getValue(), ContentType.create((String)"text/plain", (String)encoding.getDescription()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)boundary)) {
                builder.setBoundary(boundary);
            }
            builder.addBinaryBody(fileName, inputStream, ContentType.create((String)"multipart/form-data", (String)encoding.getDescription()), fileName);
            httpRequestBase.setEntity(builder.build());
            requestConfig = null == requestConfig ? defaultRequestConfig : requestConfig;
            httpRequestBase.setConfig(requestConfig);
            httpRequestBase.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0");
            httpRequestBase.addHeader("Connection", "keep-alive");
            httpRequestBase.addHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8");
            httpRequestBase.addHeader("Accept-Charset", encoding.getDescription());
            if (MapUtils.isNotEmpty(headerParams)) {
                for (Map.Entry<String, String> entry : headerParams.entrySet()) {
                    httpRequestBase.addHeader(entry.getKey(), entry.getValue());
                }
            }
            return HttpClientUtils.getCachingClient(uri.getHost(), uri.getPort(), retryNum, requestConfig).execute((HttpUriRequest)httpRequestBase, (HttpContext)HttpClientContext.create());
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6HTTP\u8fde\u63a5\u8fd4\u56de\u5b9e\u4f8b error:", (Throwable)e);
            return null;
        }
    }

    private static CloseableHttpClient getCachingClient(String host, int port, final int retryNum, RequestConfig requestConfig) {
        PlainConnectionSocketFactory connectionSocketFactory = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory layeredConnectionSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)connectionSocketFactory).register("https", (Object)layeredConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(20);
        HttpHost httpHost = new HttpHost(host, port);
        cm.setMaxPerRoute(new HttpRoute(httpHost), 50);
        HttpClientBuilder httpClientBuilder = CachingHttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(null == requestConfig ? defaultRequestConfig : requestConfig);
        if (retryNum > 0) {
            HttpRequestRetryHandler retryHandler = new HttpRequestRetryHandler(){

                public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                    if (executionCount >= retryNum || exception instanceof SSLHandshakeException || exception instanceof InterruptedIOException || exception instanceof UnknownHostException || exception instanceof SSLException) {
                        return false;
                    }
                    if (exception instanceof NoHttpResponseException || exception instanceof SocketException) {
                        return true;
                    }
                    HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                    HttpRequest request = clientContext.getRequest();
                    return !(request instanceof HttpEntityEnclosingRequest);
                }
            };
            httpClientBuilder.setRetryHandler(retryHandler);
        }
        return httpClientBuilder.build();
    }

    public static URI convertToURI(String uriStr) {
        try {
            return new URI(uriStr);
        }
        catch (URISyntaxException e) {
            log.error("\u8f6c\u5316\u6210URI error:", (Throwable)e);
            return null;
        }
    }

    public static enum HttpMethod {
        GET,
        POST;

    }

    public static enum Encoding {
        UTF8("UTF-8"),
        GBK("GBK"),
        GB2312("GB2312");

        private String description;

        private Encoding(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

