/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public final class JsonUtils {
    private static final String DEFAULT_TIME_ZONE = "GMT+8";
    private static final String DEFAULT_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T jsonToObject(String jsonStr, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u53cd\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    public static <T> T jsonToObject(String jsonStr, TypeReference typeReference) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, typeReference);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u53cd\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    public static <T> T jsonToObject(String jsonStr, Class<?> collectionClass, Class<?> ... elementClasses) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u53cd\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    public static String objectToJson(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    static {
        OBJECT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        OBJECT_MAPPER.setTimeZone(TimeZone.getTimeZone(DEFAULT_TIME_ZONE));
        OBJECT_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat(DEFAULT_TIME_PATTERN));
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

