/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.util;

import org.apache.commons.lang3.StringUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

public final class QuartzUtils {
    private static SchedulerFactory schedulerFactory = new StdSchedulerFactory();

    private QuartzUtils() {
    }

    public static void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class<? extends Job> jobClass, String cronExpression) {
        try {
            Scheduler scheduler = schedulerFactory.getScheduler();
            JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).build();
            jobDetail.getJobDataMap().put("jobName", jobName);
            jobDetail.getJobDataMap().put("jobGroupName", jobGroupName);
            jobDetail.getJobDataMap().put("triggerName", triggerName);
            jobDetail.getJobDataMap().put("triggerGroupName", triggerGroupName);
            jobDetail.getJobDataMap().put("jobClass", jobClass);
            jobDetail.getJobDataMap().put("cronExpression", cronExpression);
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.withIdentity(triggerName, triggerGroupName);
            triggerBuilder.startNow();
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression));
            CronTrigger trigger = (CronTrigger)triggerBuilder.build();
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (!scheduler.isShutdown()) {
                scheduler.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void modifyJob(String triggerName, String triggerGroupName, String newCronExpression) {
        try {
            Scheduler scheduler = schedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
            CronTrigger trigger = (CronTrigger)scheduler.getTrigger(triggerKey);
            if (null == trigger) {
                return;
            }
            String oldCronExpression = trigger.getCronExpression();
            if (!StringUtils.equalsIgnoreCase((CharSequence)oldCronExpression, (CharSequence)newCronExpression)) {
                TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
                triggerBuilder.withIdentity(triggerName, triggerGroupName);
                triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)newCronExpression));
                scheduler.rescheduleJob(triggerKey, triggerBuilder.build());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName) {
        try {
            Scheduler scheduler = schedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
            scheduler.pauseTrigger(triggerKey);
            scheduler.unscheduleJob(triggerKey);
            scheduler.deleteJob(JobKey.jobKey((String)jobName, (String)jobGroupName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void startJobs() {
        try {
            Scheduler scheduler = schedulerFactory.getScheduler();
            scheduler.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void shutdownJobs() {
        try {
            Scheduler scheduler = schedulerFactory.getScheduler();
            if (!scheduler.isShutdown()) {
                scheduler.shutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

