/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.util;

import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.cglib.core.ReflectUtils;

public final class XMLUtils {
    private static final BeanUtilsBean beanUtilsBean;

    public static <T> T parseXML(String xmlStr, Class<T> clazz) {
        Object targetObject = ReflectUtils.newInstance(clazz);
        try {
            Document document = XMLUtils.getDocument(xmlStr);
            Element rootElement = document.getRootElement();
            targetObject = XMLUtils.recursionEleParse(rootElement, targetObject, clazz, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)targetObject;
    }

    private static <T> T recursionEleParse(Element rootElement, T targetObject, Class<T> clazz, Object objValue, List<T> arrayList) {
        Iterator element = rootElement.elementIterator();
        while (element.hasNext()) {
            Element childElementNode = (Element)element.next();
            String elementName = childElementNode.getName();
            String lowCaseEleName = StringUtils.uncapitalize((String)elementName);
            Field field = XMLUtils.getFiled(clazz, lowCaseEleName);
            if (field == null) continue;
            Boolean hasElement = childElementNode.elements().size() > 0;
            Boolean hasAttrs = CollectionUtils.isNotEmpty((Collection)childElementNode.attributes());
            if (hasElement.booleanValue() || hasAttrs.booleanValue()) {
                Object childObjectVal;
                if (field.getType() == List.class) {
                    Class genericClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    if (arrayList != null) {
                        arrayList = (List)XMLUtils.getValue(field, targetObject);
                    }
                    if (arrayList == null) {
                        arrayList = XMLUtils.instanceArrayList();
                    }
                    childObjectVal = ReflectUtils.newInstance((Class)genericClass);
                    if (hasElement.booleanValue()) {
                        XMLUtils.recursionEleParse(childElementNode, childObjectVal, genericClass, null, arrayList);
                    }
                    if (hasAttrs.booleanValue()) {
                        XMLUtils.recursionAttrParse(rootElement, childObjectVal, genericClass, childElementNode.attributes());
                    }
                    arrayList.add(childObjectVal);
                    objValue = arrayList;
                } else {
                    try {
                        Class sigleClazz = (Class)field.getGenericType();
                        childObjectVal = ReflectUtils.newInstance((Class)sigleClazz);
                        if (hasElement.booleanValue()) {
                            XMLUtils.recursionEleParse(childElementNode, childObjectVal, sigleClazz, null, arrayList);
                        }
                        if (hasAttrs.booleanValue()) {
                            XMLUtils.recursionAttrParse(childElementNode, childObjectVal, sigleClazz, childElementNode.attributes());
                        }
                        objValue = childObjectVal;
                    }
                    catch (Exception e) {
                        System.out.println(lowCaseEleName + "");
                        e.printStackTrace();
                    }
                }
            } else {
                objValue = null;
            }
            if (objValue == null) {
                Element childElement = childElementNode;
                String value = childElement.getTextTrim();
                Object parameterValue = XMLUtils.parseValueByField(field, value = XMLUtils.unicode(value, "utf-8"));
                if (parameterValue == null) continue;
                XMLUtils.setValue(targetObject, lowCaseEleName, parameterValue);
                continue;
            }
            XMLUtils.setValue(targetObject, lowCaseEleName, objValue);
        }
        return targetObject;
    }

    private static <T> T recursionAttrParse(Element rootElement, T currentEleObject, Class<T> currentEleObjectClazz, List<Attribute> attributes) {
        if (CollectionUtils.isNotEmpty(attributes)) {
            for (Attribute attribute : attributes) {
                String attrName = attribute.getName();
                String lowCaseEleName = StringUtils.uncapitalize((String)attrName);
                String attrValue = attribute.getValue();
                attrValue = XMLUtils.unicode(attrValue, "utf-8");
                Field field = XMLUtils.getFiled(currentEleObjectClazz, lowCaseEleName);
                if (field == null) continue;
                Object parameterValue = XMLUtils.parseValueByField(field, attrValue);
                XMLUtils.setValue(currentEleObject, lowCaseEleName, parameterValue);
            }
        }
        return currentEleObject;
    }

    private static List<?> instanceArrayList() {
        try {
            return (List)ArrayList.class.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return new ArrayList();
    }

    public static Object parseValueByField(Field field, Object value) {
        if (value == null || StringUtils.isBlank((CharSequence)("" + value))) {
            return null;
        }
        if (value.getClass() != Number.class && (Class)field.getGenericType() == Number.class) {
            value = (Number)value;
        } else if ((value.getClass() == String.class || (Class)field.getGenericType() != String.class) && value.getClass() != Date.class && (Class)field.getGenericType() == Date.class) {
            try {
                value = DateUtils.parseDate((String)value.toString(), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private static void setValue(Object targetObject, String fieldName, Object value) {
        try {
            beanUtilsBean.setProperty(targetObject, fieldName, value);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static Object getValue(Field field, Object targetObject) {
        try {
            return field.get(targetObject);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Document getDocument(String xmlStr) throws DocumentException {
        return new SAXReader().read((Reader)new StringReader(xmlStr));
    }

    public static String unicode(String str, String charset) {
        try {
            str = StringUtils.trim((String)str);
            return new String(str.getBytes(charset), charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    public static Field getFiled(Class clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    static {
        ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean(){

            public void register(Converter converter, Class clazz) {
                super.register((Converter)new IntegerConverter(null), Integer.class);
                super.register((Converter)new BooleanConverter(null), Boolean.class);
                super.register((Converter)new LongConverter(null), Long.class);
                super.register((Converter)new StringConverter(null), String.class);
                super.register((Converter)new DateConverter(null), Timestamp.class);
                super.register((Converter)new BigDecimalConverter(null), BigDecimal.class);
                super.register((Converter)new DoubleConverter(null), Double.class);
            }
        };
        beanUtilsBean = new BeanUtilsBean(convertUtilsBean);
    }
}

