/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.validator;

import com.biz.pull.orders.annotation.BigDecimalFractionAnnotation;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;

public class BigDecimalFractionValidator
implements ConstraintValidator<BigDecimalFractionAnnotation, Object> {
    private int fraction;

    public void initialize(BigDecimalFractionAnnotation bigDecimalFractionAnnotation) {
        this.fraction = bigDecimalFractionAnnotation.fraction();
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        if (null == value) {
            return true;
        }
        try {
            List<BigDecimal> valueList = Lists.newArrayList();
            if (value.getClass().isAssignableFrom(List.class)) {
                valueList = (List)value;
            } else if (value instanceof BigDecimal) {
                valueList.add((BigDecimal)value);
            }
            if (CollectionUtils.isNotEmpty((Collection)valueList)) {
                for (BigDecimal bigDecimalValue : valueList) {
                    BigDecimal newValue;
                    if (bigDecimalValue.compareTo(newValue = bigDecimalValue.setScale(this.fraction, 1)) == 0) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

