/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.validator;

import com.biz.pull.orders.annotation.CronExpressionAnnotation;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.impl.triggers.CronTriggerImpl;

public class CronExpressionValidator
implements ConstraintValidator<CronExpressionAnnotation, String> {
    private String forceCheck;

    public void initialize(CronExpressionAnnotation cronExpression) {
        this.forceCheck = cronExpression.forceCheck();
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return true;
        }
        try {
            CronTriggerImpl trigger = new CronTriggerImpl();
            trigger.setCronExpression(value);
            boolean isForceCheck = BooleanUtils.toBoolean((String)this.forceCheck);
            if (isForceCheck) {
                Date date = trigger.computeFirstFireTime(null);
                return date != null && date.after(new Date());
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

