/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.validator;

import com.biz.pull.orders.annotation.IntegerRangeAnnotation;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;

public class IntegerRangeValidator
implements ConstraintValidator<IntegerRangeAnnotation, Object> {
    private int min;
    private int max;

    public void initialize(IntegerRangeAnnotation integerRangeAnnotation) {
        this.min = integerRangeAnnotation.min();
        this.max = integerRangeAnnotation.max();
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        if (null == value) {
            return true;
        }
        try {
            String string = value.toString();
            List<Integer> valueList = Lists.newArrayList();
            if (value.getClass().isAssignableFrom(List.class)) {
                valueList = (List)value;
            } else if (value instanceof String && string != null) {
                valueList.add(Integer.valueOf(string));
            }
            if (CollectionUtils.isNotEmpty((Collection)valueList)) {
                for (Integer integerValue : valueList) {
                    if (integerValue >= this.min && integerValue <= this.max) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

