/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.validator;

import com.biz.pull.orders.annotation.StringSizeAnnotation;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class StringSizeValidator
implements ConstraintValidator<StringSizeAnnotation, Object> {
    private int min;
    private int max;

    public void initialize(StringSizeAnnotation stringSizeAnnotation) {
        this.min = stringSizeAnnotation.min();
        this.max = stringSizeAnnotation.max();
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        if (null == value) {
            return true;
        }
        try {
            List<String> valueList = Lists.newArrayList();
            if (value.getClass().isAssignableFrom(List.class)) {
                valueList = (List)value;
            } else if (value instanceof String) {
                valueList.add((String)value);
            }
            if (CollectionUtils.isNotEmpty((Collection)valueList)) {
                for (String stringValue : valueList) {
                    int length = StringUtils.length((CharSequence)stringValue);
                    if (length >= this.min && length <= this.max) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

