/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.validator;

import com.biz.pull.orders.annotation.SystemParamsAnnotation;
import com.biz.pull.orders.constant.SystemParamsEnum;
import com.biz.pull.orders.util.JsonUtils;
import com.biz.pull.orders.vo.Pair;
import com.google.common.collect.Lists;
import java.sql.Date;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SystemParamsValidator
implements ConstraintValidator<SystemParamsAnnotation, String> {
    private static List<Pair<String, Object>> systemParamList = Lists.newArrayList();

    public void initialize(SystemParamsAnnotation systemParamsAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return true;
        }
        List systemParamsPairList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            systemParamsPairList = (List)JsonUtils.jsonToObject(value, List.class, Pair.class);
        }
        try {
            if (CollectionUtils.isNotEmpty((Collection)systemParamsPairList)) {
                for (Pair systemParamsPair : systemParamsPairList) {
                    String systemParamsKey = (String)systemParamsPair.getKey();
                    String systemParamsValue = (String)systemParamsPair.getValue();
                    if (!StringUtils.isNotBlank((CharSequence)systemParamsKey) && !StringUtils.isNotBlank((CharSequence)systemParamsValue)) continue;
                    Object rule = this.getAllowRule(systemParamsKey);
                    if (null == rule) {
                        return false;
                    }
                    if (rule instanceof Pattern) {
                        Pattern allowPattern = (Pattern)rule;
                        if (allowPattern.matcher(systemParamsValue).matches()) continue;
                        return false;
                    }
                    if (!(rule instanceof Class)) continue;
                    Class allowClass = (Class)rule;
                    Object convertResult = ConvertUtils.convert((String)systemParamsValue, (Class)allowClass);
                    if (allowClass == Date.class || Objects.equals(convertResult.toString(), systemParamsValue)) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Object getAllowRule(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            for (Pair<String, Object> stringClassPair : systemParamList) {
                if (!Objects.equals(StringUtils.trim((String)key), stringClassPair.getKey())) continue;
                return stringClassPair.getValue();
            }
        }
        return null;
    }

    static {
        systemParamList.add(new Pair<String, Pattern>(SystemParamsEnum.TIME_INTERVAL.getDescription(), Pattern.compile("^[1-9]\\d*[h,d]$")));
        systemParamList.add(new Pair<String, Class<Date>>(SystemParamsEnum.EXCLUDE_TIME.getDescription(), Date.class));
    }
}

