/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.vo;

import com.biz.pull.orders.util.JsonUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class PageResult<E>
implements Serializable {
    private static final long serialVersionUID = 1048029186252168978L;
    private int currentPage = 0;
    private int size = 10;
    private transient List<E> result;
    private int totalSize;

    public PageResult() {
        this.totalSize = 0;
        this.result = Collections.emptyList();
    }

    public PageResult(int currentPage, int size, long total, List<E> result) {
        this.totalSize = (int)total;
        this.currentPage = currentPage;
        this.size = size;
        this.result = result;
    }

    public Boolean hasPrevious() {
        return this.currentPage > 1;
    }

    public Boolean hasNext() {
        return this.result != null && this.currentPage * this.size < this.totalSize;
    }

    public int getTotalPage() {
        return this.size == 0 ? 0 : (this.totalSize % this.size == 0 ? this.totalSize / this.size : this.totalSize / this.size + 1);
    }

    public String toString() {
        return JsonUtils.objectToJson(this);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getSize() {
        return this.size;
    }

    public List<E> getResult() {
        return this.result;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setResult(List<E> result) {
        this.result = result;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }
}

