/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.vo.api.accept;

import com.biz.pull.orders.annotation.EnumCodeAnnotation;
import com.biz.pull.orders.annotation.StringDateFormatAnnotation;
import com.biz.pull.orders.constant.api.OrderStateEnum;
import com.biz.pull.orders.constant.api.OrderTypeEnum;
import com.biz.pull.orders.constant.api.PrescriptionTypeEnum;
import com.biz.pull.orders.constant.api.SaleTypeEnum;
import com.biz.pull.orders.constant.api.ShippingTypeEnum;
import com.biz.pull.orders.util.JsonUtils;
import com.biz.pull.orders.vo.api.accept.AdjustFee;
import com.biz.pull.orders.vo.api.accept.ConsigneeInfo;
import com.biz.pull.orders.vo.api.accept.InvoiceInfo;
import com.biz.pull.orders.vo.api.accept.OperationInfo;
import com.biz.pull.orders.vo.api.accept.OrderAmountInfo;
import com.biz.pull.orders.vo.api.accept.PayInfo;
import com.biz.pull.orders.vo.api.accept.ProductInfo;
import com.biz.pull.orders.vo.api.accept.StorePickUpInfo;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotEmpty;

public class CommonOrder
implements Serializable {
    private static final long serialVersionUID = -1451302797876270975L;
    @Size(min=1, max=100, message="outerOrderSources\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(min=1, max=100, message="outerOrderSources\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String outerOrderSources;
    @Size(max=100, message="innerOrderSources\u7684\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(max=100, message="innerOrderSources\u7684\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String innerOrderSources;
    @Size(min=1, max=100, message="shopId\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(min=1, max=100, message="shopId\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String shopId;
    @Size(min=1, max=100, message="orderId\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(min=1, max=100, message="orderId\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String orderId;
    @NotNull(message="orderState\u4e0d\u80fd\u4e3a\u7a7a")
    @EnumCodeAnnotation(enumCodeClass=OrderStateEnum.class, message="orderState\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @NotNull(message="orderState\u4e0d\u80fd\u4e3a\u7a7a") Integer orderState;
    @Size(max=100, message="parentOrderId\u7684\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(max=100, message="parentOrderId\u7684\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String parentOrderId;
    @Size(max=100, message="outerOrderId\u7684\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(max=100, message="outerOrderId\u7684\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String outerOrderId;
    @NotNull(message="orderType\u4e0d\u80fd\u4e3a\u7a7a")
    @EnumCodeAnnotation(enumCodeClass=OrderTypeEnum.class, message="orderType\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @NotNull(message="orderType\u4e0d\u80fd\u4e3a\u7a7a") Integer orderType;
    @NotNull(message="shippingType\u4e0d\u80fd\u4e3a\u7a7a")
    @EnumCodeAnnotation(enumCodeClass=ShippingTypeEnum.class, message="shippingType\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @NotNull(message="shippingType\u4e0d\u80fd\u4e3a\u7a7a") Integer shippingType;
    @NotNull(message="prescriptionType\u4e0d\u80fd\u4e3a\u7a7a")
    @EnumCodeAnnotation(enumCodeClass=PrescriptionTypeEnum.class, message="prescriptionType\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @NotNull(message="prescriptionType\u4e0d\u80fd\u4e3a\u7a7a") Integer prescriptionType;
    @Size(max=100, message="prescriptionLimitTime\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(max=100, message="prescriptionLimitTime\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String prescriptionLimitTime;
    @NotNull(message="saleType\u4e0d\u80fd\u4e3a\u7a7a")
    @EnumCodeAnnotation(enumCodeClass=SaleTypeEnum.class, message="saleType\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @NotNull(message="saleType\u4e0d\u80fd\u4e3a\u7a7a") Integer saleType;
    @Size(min=1, max=100, message="orderStartTime\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    @StringDateFormatAnnotation(pattern="yyyy-MM-dd HH:mm:ss", message="orderStartTime\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @Size(min=1, max=100, message="orderStartTime\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String orderStartTime;
    @Size(max=100, message="orderEndTime\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    @StringDateFormatAnnotation(pattern="yyyy-MM-dd HH:mm:ss", message="orderEndTime\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @Size(max=100, message="orderEndTime\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String orderEndTime;
    @Size(min=1, max=100, message="lastModifyTime\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    @StringDateFormatAnnotation(pattern="yyyy-MM-dd HH:mm:ss", message="lastModifyTime\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @Size(min=1, max=100, message="lastModifyTime\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String lastModifyTime;
    @Size(max=100, message="warehouseId\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(max=100, message="warehouseId\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String warehouseId;
    private Boolean preSaleOrder = false;
    private Boolean energySubsidyOrder = false;
    private Boolean serviceOrder = false;
    private Boolean wwwOrder = false;
    private Boolean adjustIsExists = false;
    @Size(max=100, message="adjustId\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(max=100, message="adjustId\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String adjustId;
    @Valid
    private AdjustFee adjustFee;
    private Boolean storePickUp = false;
    private StorePickUpInfo storePickUpInfo;
    private Boolean sameCityDistribution = false;
    @Size(max=100, message="sameCityDistributionTimeLimit\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(max=100, message="sameCityDistributionTimeLimit\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String sameCityDistributionTimeLimit;
    @Size(max=100, message="buyerNick\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(max=100, message="buyerNick\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String buyerNick;
    @Size(max=500, message="buyerRemark\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7500\u4f4d\u5b57\u7b26")
    private @Size(max=500, message="buyerRemark\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7500\u4f4d\u5b57\u7b26") String buyerRemark;
    @Size(max=100, message="venderId\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(max=100, message="venderId\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String venderId;
    @Size(max=100, message="sellerNick\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(max=100, message="sellerNick\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String sellerNick;
    @Size(max=500, message="sellerRemark\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7500\u4f4d\u5b57\u7b26")
    private @Size(max=500, message="sellerRemark\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7500\u4f4d\u5b57\u7b26") String sellerRemark;
    @Valid
    @NotNull(message="payInfo\u4e0d\u80fd\u4e3a\u7a7a")
    private @Valid @NotNull(message="payInfo\u4e0d\u80fd\u4e3a\u7a7a") PayInfo payInfo;
    @Valid
    @NotNull(message="consigneeInfo\u4e0d\u80fd\u4e3a\u7a7a")
    private @Valid @NotNull(message="consigneeInfo\u4e0d\u80fd\u4e3a\u7a7a") ConsigneeInfo consigneeInfo;
    @Valid
    private List<OperationInfo> operationInfoList;
    @Valid
    private InvoiceInfo invoiceInfo;
    @Valid
    @NotNull(message="orderAmountInfo\u4e0d\u80fd\u4e3a\u7a7a")
    private @Valid @NotNull(message="orderAmountInfo\u4e0d\u80fd\u4e3a\u7a7a") OrderAmountInfo orderAmountInfo;
    @Valid
    @NotEmpty(message="productInfoList\u4e0d\u80fd\u4e3a\u7a7a")
    private @Valid @NotEmpty(message="productInfoList\u4e0d\u80fd\u4e3a\u7a7a") List<ProductInfo> productInfoList;
    @Size(min=1, max=50000, message="originPlatformOrderJson\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc750000\u4f4d\u5b57\u7b26")
    private @Size(min=1, max=50000, message="originPlatformOrderJson\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc750000\u4f4d\u5b57\u7b26") String originPlatformOrderJson;

    public String toString() {
        return JsonUtils.objectToJson(this);
    }

    public String getOuterOrderSources() {
        return this.outerOrderSources;
    }

    public String getInnerOrderSources() {
        return this.innerOrderSources;
    }

    public String getShopId() {
        return this.shopId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public Integer getOrderState() {
        return this.orderState;
    }

    public String getParentOrderId() {
        return this.parentOrderId;
    }

    public String getOuterOrderId() {
        return this.outerOrderId;
    }

    public Integer getOrderType() {
        return this.orderType;
    }

    public Integer getShippingType() {
        return this.shippingType;
    }

    public Integer getPrescriptionType() {
        return this.prescriptionType;
    }

    public String getPrescriptionLimitTime() {
        return this.prescriptionLimitTime;
    }

    public Integer getSaleType() {
        return this.saleType;
    }

    public String getOrderStartTime() {
        return this.orderStartTime;
    }

    public String getOrderEndTime() {
        return this.orderEndTime;
    }

    public String getLastModifyTime() {
        return this.lastModifyTime;
    }

    public String getWarehouseId() {
        return this.warehouseId;
    }

    public Boolean getPreSaleOrder() {
        return this.preSaleOrder;
    }

    public Boolean getEnergySubsidyOrder() {
        return this.energySubsidyOrder;
    }

    public Boolean getServiceOrder() {
        return this.serviceOrder;
    }

    public Boolean getWwwOrder() {
        return this.wwwOrder;
    }

    public Boolean getAdjustIsExists() {
        return this.adjustIsExists;
    }

    public String getAdjustId() {
        return this.adjustId;
    }

    public AdjustFee getAdjustFee() {
        return this.adjustFee;
    }

    public Boolean getStorePickUp() {
        return this.storePickUp;
    }

    public StorePickUpInfo getStorePickUpInfo() {
        return this.storePickUpInfo;
    }

    public Boolean getSameCityDistribution() {
        return this.sameCityDistribution;
    }

    public String getSameCityDistributionTimeLimit() {
        return this.sameCityDistributionTimeLimit;
    }

    public String getBuyerNick() {
        return this.buyerNick;
    }

    public String getBuyerRemark() {
        return this.buyerRemark;
    }

    public String getVenderId() {
        return this.venderId;
    }

    public String getSellerNick() {
        return this.sellerNick;
    }

    public String getSellerRemark() {
        return this.sellerRemark;
    }

    public PayInfo getPayInfo() {
        return this.payInfo;
    }

    public ConsigneeInfo getConsigneeInfo() {
        return this.consigneeInfo;
    }

    public List<OperationInfo> getOperationInfoList() {
        return this.operationInfoList;
    }

    public InvoiceInfo getInvoiceInfo() {
        return this.invoiceInfo;
    }

    public OrderAmountInfo getOrderAmountInfo() {
        return this.orderAmountInfo;
    }

    public List<ProductInfo> getProductInfoList() {
        return this.productInfoList;
    }

    public String getOriginPlatformOrderJson() {
        return this.originPlatformOrderJson;
    }

    public void setOuterOrderSources(String outerOrderSources) {
        this.outerOrderSources = outerOrderSources;
    }

    public void setInnerOrderSources(String innerOrderSources) {
        this.innerOrderSources = innerOrderSources;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setOrderState(Integer orderState) {
        this.orderState = orderState;
    }

    public void setParentOrderId(String parentOrderId) {
        this.parentOrderId = parentOrderId;
    }

    public void setOuterOrderId(String outerOrderId) {
        this.outerOrderId = outerOrderId;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public void setShippingType(Integer shippingType) {
        this.shippingType = shippingType;
    }

    public void setPrescriptionType(Integer prescriptionType) {
        this.prescriptionType = prescriptionType;
    }

    public void setPrescriptionLimitTime(String prescriptionLimitTime) {
        this.prescriptionLimitTime = prescriptionLimitTime;
    }

    public void setSaleType(Integer saleType) {
        this.saleType = saleType;
    }

    public void setOrderStartTime(String orderStartTime) {
        this.orderStartTime = orderStartTime;
    }

    public void setOrderEndTime(String orderEndTime) {
        this.orderEndTime = orderEndTime;
    }

    public void setLastModifyTime(String lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public void setPreSaleOrder(Boolean preSaleOrder) {
        this.preSaleOrder = preSaleOrder;
    }

    public void setEnergySubsidyOrder(Boolean energySubsidyOrder) {
        this.energySubsidyOrder = energySubsidyOrder;
    }

    public void setServiceOrder(Boolean serviceOrder) {
        this.serviceOrder = serviceOrder;
    }

    public void setWwwOrder(Boolean wwwOrder) {
        this.wwwOrder = wwwOrder;
    }

    public void setAdjustIsExists(Boolean adjustIsExists) {
        this.adjustIsExists = adjustIsExists;
    }

    public void setAdjustId(String adjustId) {
        this.adjustId = adjustId;
    }

    public void setAdjustFee(AdjustFee adjustFee) {
        this.adjustFee = adjustFee;
    }

    public void setStorePickUp(Boolean storePickUp) {
        this.storePickUp = storePickUp;
    }

    public void setStorePickUpInfo(StorePickUpInfo storePickUpInfo) {
        this.storePickUpInfo = storePickUpInfo;
    }

    public void setSameCityDistribution(Boolean sameCityDistribution) {
        this.sameCityDistribution = sameCityDistribution;
    }

    public void setSameCityDistributionTimeLimit(String sameCityDistributionTimeLimit) {
        this.sameCityDistributionTimeLimit = sameCityDistributionTimeLimit;
    }

    public void setBuyerNick(String buyerNick) {
        this.buyerNick = buyerNick;
    }

    public void setBuyerRemark(String buyerRemark) {
        this.buyerRemark = buyerRemark;
    }

    public void setVenderId(String venderId) {
        this.venderId = venderId;
    }

    public void setSellerNick(String sellerNick) {
        this.sellerNick = sellerNick;
    }

    public void setSellerRemark(String sellerRemark) {
        this.sellerRemark = sellerRemark;
    }

    public void setPayInfo(PayInfo payInfo) {
        this.payInfo = payInfo;
    }

    public void setConsigneeInfo(ConsigneeInfo consigneeInfo) {
        this.consigneeInfo = consigneeInfo;
    }

    public void setOperationInfoList(List<OperationInfo> operationInfoList) {
        this.operationInfoList = operationInfoList;
    }

    public void setInvoiceInfo(InvoiceInfo invoiceInfo) {
        this.invoiceInfo = invoiceInfo;
    }

    public void setOrderAmountInfo(OrderAmountInfo orderAmountInfo) {
        this.orderAmountInfo = orderAmountInfo;
    }

    public void setProductInfoList(List<ProductInfo> productInfoList) {
        this.productInfoList = productInfoList;
    }

    public void setOriginPlatformOrderJson(String originPlatformOrderJson) {
        this.originPlatformOrderJson = originPlatformOrderJson;
    }
}

