/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.vo.api.accept;

import com.biz.pull.orders.annotation.BigDecimalFractionAnnotation;
import com.biz.pull.orders.annotation.EnumCodeAnnotation;
import com.biz.pull.orders.constant.api.FreightRiskTypeEnum;
import com.biz.pull.orders.serializer.BigDecimalSerializer;
import com.biz.pull.orders.util.JsonUtils;
import com.biz.pull.orders.vo.api.accept.ChargeInfo;
import com.biz.pull.orders.vo.api.accept.CouponInfo;
import com.biz.pull.orders.vo.api.accept.EnergySubsidyInfo;
import com.biz.pull.orders.vo.api.accept.PromoInfo;
import com.biz.pull.orders.vo.api.accept.TaxInfo;
import com.biz.pull.orders.vo.api.accept.TipInfo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class OrderAmountInfo
implements Serializable {
    private static final long serialVersionUID = -5018624729097824965L;
    @NotNull(message="orderTotalAmount\u4e0d\u80fd\u4e3a\u7a7a")
    @BigDecimalFractionAnnotation(fraction=2, message="orderTotalAmount\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private @NotNull(message="orderTotalAmount\u4e0d\u80fd\u4e3a\u7a7a") BigDecimal orderTotalAmount;
    @NotNull(message="sellerShouldAccept\u4e0d\u80fd\u4e3a\u7a7a")
    @BigDecimalFractionAnnotation(fraction=2, message="sellerShouldAccept\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private @NotNull(message="sellerShouldAccept\u4e0d\u80fd\u4e3a\u7a7a") BigDecimal sellerShouldAccept;
    @NotNull(message="buyerShouldPaid\u4e0d\u80fd\u4e3a\u7a7a")
    @BigDecimalFractionAnnotation(fraction=2, message="buyerShouldPaid\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private @NotNull(message="buyerShouldPaid\u4e0d\u80fd\u4e3a\u7a7a") BigDecimal buyerShouldPaid;
    @BigDecimalFractionAnnotation(fraction=2, message="freightAmount\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal freightAmount = BigDecimal.ZERO;
    @BigDecimalFractionAnnotation(fraction=2, message="freightAmount\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal freightRisk = BigDecimal.ZERO;
    @EnumCodeAnnotation(enumCodeClass=FreightRiskTypeEnum.class, message="freightRiskType\u683c\u5f0f\u4e0d\u6b63\u786e")
    private Integer freightRiskType = FreightRiskTypeEnum.NONE.getCode();
    @BigDecimalFractionAnnotation(fraction=2, message="discount\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal discount = BigDecimal.ZERO;
    @Valid
    private List<CouponInfo> couponInfoList;
    @BigDecimalFractionAnnotation(fraction=2, message="taxFee\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal taxFee = BigDecimal.ZERO;
    @Valid
    private TaxInfo taxInfo;
    @BigDecimalFractionAnnotation(fraction=2, message="taxFee\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal energySubsidyAmount = BigDecimal.ZERO;
    @Valid
    private List<EnergySubsidyInfo> energySubsidyInfoList;
    @BigDecimalFractionAnnotation(fraction=2, message="promoDeductAmount\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal promoDeductAmount = BigDecimal.ZERO;
    @Valid
    private List<PromoInfo> promoInfoList;
    @BigDecimalFractionAnnotation(fraction=2, message="charge\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal charge = BigDecimal.ZERO;
    @Valid
    private List<ChargeInfo> chargeInfoList;
    @BigDecimalFractionAnnotation(fraction=2, message="tip\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal tip = BigDecimal.ZERO;
    @Valid
    private List<TipInfo> tipInfoList;
    @BigDecimalFractionAnnotation(fraction=2, message="packageCharge\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal packageCharge = BigDecimal.ZERO;

    public String toString() {
        return JsonUtils.objectToJson(this);
    }

    public BigDecimal getOrderTotalAmount() {
        return this.orderTotalAmount;
    }

    public BigDecimal getSellerShouldAccept() {
        return this.sellerShouldAccept;
    }

    public BigDecimal getBuyerShouldPaid() {
        return this.buyerShouldPaid;
    }

    public BigDecimal getFreightAmount() {
        return this.freightAmount;
    }

    public BigDecimal getFreightRisk() {
        return this.freightRisk;
    }

    public Integer getFreightRiskType() {
        return this.freightRiskType;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public List<CouponInfo> getCouponInfoList() {
        return this.couponInfoList;
    }

    public BigDecimal getTaxFee() {
        return this.taxFee;
    }

    public TaxInfo getTaxInfo() {
        return this.taxInfo;
    }

    public BigDecimal getEnergySubsidyAmount() {
        return this.energySubsidyAmount;
    }

    public List<EnergySubsidyInfo> getEnergySubsidyInfoList() {
        return this.energySubsidyInfoList;
    }

    public BigDecimal getPromoDeductAmount() {
        return this.promoDeductAmount;
    }

    public List<PromoInfo> getPromoInfoList() {
        return this.promoInfoList;
    }

    public BigDecimal getCharge() {
        return this.charge;
    }

    public List<ChargeInfo> getChargeInfoList() {
        return this.chargeInfoList;
    }

    public BigDecimal getTip() {
        return this.tip;
    }

    public List<TipInfo> getTipInfoList() {
        return this.tipInfoList;
    }

    public BigDecimal getPackageCharge() {
        return this.packageCharge;
    }

    public void setOrderTotalAmount(BigDecimal orderTotalAmount) {
        this.orderTotalAmount = orderTotalAmount;
    }

    public void setSellerShouldAccept(BigDecimal sellerShouldAccept) {
        this.sellerShouldAccept = sellerShouldAccept;
    }

    public void setBuyerShouldPaid(BigDecimal buyerShouldPaid) {
        this.buyerShouldPaid = buyerShouldPaid;
    }

    public void setFreightAmount(BigDecimal freightAmount) {
        this.freightAmount = freightAmount;
    }

    public void setFreightRisk(BigDecimal freightRisk) {
        this.freightRisk = freightRisk;
    }

    public void setFreightRiskType(Integer freightRiskType) {
        this.freightRiskType = freightRiskType;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public void setCouponInfoList(List<CouponInfo> couponInfoList) {
        this.couponInfoList = couponInfoList;
    }

    public void setTaxFee(BigDecimal taxFee) {
        this.taxFee = taxFee;
    }

    public void setTaxInfo(TaxInfo taxInfo) {
        this.taxInfo = taxInfo;
    }

    public void setEnergySubsidyAmount(BigDecimal energySubsidyAmount) {
        this.energySubsidyAmount = energySubsidyAmount;
    }

    public void setEnergySubsidyInfoList(List<EnergySubsidyInfo> energySubsidyInfoList) {
        this.energySubsidyInfoList = energySubsidyInfoList;
    }

    public void setPromoDeductAmount(BigDecimal promoDeductAmount) {
        this.promoDeductAmount = promoDeductAmount;
    }

    public void setPromoInfoList(List<PromoInfo> promoInfoList) {
        this.promoInfoList = promoInfoList;
    }

    public void setCharge(BigDecimal charge) {
        this.charge = charge;
    }

    public void setChargeInfoList(List<ChargeInfo> chargeInfoList) {
        this.chargeInfoList = chargeInfoList;
    }

    public void setTip(BigDecimal tip) {
        this.tip = tip;
    }

    public void setTipInfoList(List<TipInfo> tipInfoList) {
        this.tipInfoList = tipInfoList;
    }

    public void setPackageCharge(BigDecimal packageCharge) {
        this.packageCharge = packageCharge;
    }
}

