/*
 * Decompiled with CFR 0.152.
 */
package com.biz.pull.orders.vo.api.accept;

import com.biz.pull.orders.annotation.BigDecimalFractionAnnotation;
import com.biz.pull.orders.annotation.EnumCodeAnnotation;
import com.biz.pull.orders.annotation.StringDateFormatAnnotation;
import com.biz.pull.orders.constant.api.PayTypeEnum;
import com.biz.pull.orders.serializer.BigDecimalSerializer;
import com.biz.pull.orders.util.JsonUtils;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class PayInfo
implements Serializable {
    private static final long serialVersionUID = 4266930390352439310L;
    @NotNull(message="payType\u4e0d\u80fd\u4e3a\u7a7a")
    @EnumCodeAnnotation(enumCodeClass=PayTypeEnum.class, message="payType\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @NotNull(message="payType\u4e0d\u80fd\u4e3a\u7a7a") Integer payType;
    @Size(max=100, message="payId\u7684\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    private @Size(max=100, message="payId\u7684\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String payId;
    @Size(min=1, max=100, message="paymentTime\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26")
    @StringDateFormatAnnotation(pattern="yyyy-MM-dd HH:mm:ss", message="paymentTime\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @Size(min=1, max=100, message="paymentTime\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7100\u4f4d\u5b57\u7b26") String paymentTime;
    @NotNull(message="buyerRealPaidAmount\u4e0d\u80fd\u4e3a\u7a7a")
    @BigDecimalFractionAnnotation(fraction=2, message="buyerRealPaidAmount\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private @NotNull(message="buyerRealPaidAmount\u4e0d\u80fd\u4e3a\u7a7a") BigDecimal buyerRealPaidAmount = BigDecimal.ZERO;
    @BigDecimalFractionAnnotation(fraction=2, message="buyerRealPaidAmount\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal giftCertPaidAmount = BigDecimal.ZERO;
    @BigDecimalFractionAnnotation(fraction=2, message="giftCardPaidAmount\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal giftCardPaidAmount = BigDecimal.ZERO;
    @BigDecimalFractionAnnotation(fraction=2, message="balancePaidAmount\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal balancePaidAmount;
    @BigDecimalFractionAnnotation(fraction=2, message="integralDeductionAmount\u5c0f\u6570\u4f4d\u6700\u591a\u6709\u4e24\u4f4d")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal integralDeductionAmount;

    public String toString() {
        return JsonUtils.objectToJson(this);
    }

    public Integer getPayType() {
        return this.payType;
    }

    public String getPayId() {
        return this.payId;
    }

    public String getPaymentTime() {
        return this.paymentTime;
    }

    public BigDecimal getBuyerRealPaidAmount() {
        return this.buyerRealPaidAmount;
    }

    public BigDecimal getGiftCertPaidAmount() {
        return this.giftCertPaidAmount;
    }

    public BigDecimal getGiftCardPaidAmount() {
        return this.giftCardPaidAmount;
    }

    public BigDecimal getBalancePaidAmount() {
        return this.balancePaidAmount;
    }

    public BigDecimal getIntegralDeductionAmount() {
        return this.integralDeductionAmount;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public void setPayId(String payId) {
        this.payId = payId;
    }

    public void setPaymentTime(String paymentTime) {
        this.paymentTime = paymentTime;
    }

    public void setBuyerRealPaidAmount(BigDecimal buyerRealPaidAmount) {
        this.buyerRealPaidAmount = buyerRealPaidAmount;
    }

    public void setGiftCertPaidAmount(BigDecimal giftCertPaidAmount) {
        this.giftCertPaidAmount = giftCertPaidAmount;
    }

    public void setGiftCardPaidAmount(BigDecimal giftCardPaidAmount) {
        this.giftCardPaidAmount = giftCardPaidAmount;
    }

    public void setBalancePaidAmount(BigDecimal balancePaidAmount) {
        this.balancePaidAmount = balancePaidAmount;
    }

    public void setIntegralDeductionAmount(BigDecimal integralDeductionAmount) {
        this.integralDeductionAmount = integralDeductionAmount;
    }
}

