/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.sso.auth.vo;

import com.biz.base.enums.CommonStatus;
import com.biz.model.sso.auth.vo.AbstractDescribableItem;
import com.biz.model.sso.auth.vo.req.MenuItemVO;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(description="\u83dc\u5355\u7ec4\u5bf9\u8c61vo")
public class MenuGroupVO
extends AbstractDescribableItem {
    private static final long serialVersionUID = 3841942588052379558L;
    private String icon;
    private Collection<MenuItemVO> menuItems;
    private MenuGroupVO parent;
    private Collection<MenuGroupVO> children = Sets.newHashSet();
    private CommonStatus status = CommonStatus.ENABLE;
    private Map<String, Collection<MenuItemVO>> menuItemByType;

    public MenuGroupVO() {
    }

    public MenuGroupVO(String id, String name, String description, String icon, CommonStatus status, Integer orderIndex) {
        super(id, name, description, orderIndex, status);
        this.icon = icon;
    }

    public void addMenuItem(MenuItemVO menuItem) {
        if (this.menuItems == null) {
            this.menuItems = Lists.newArrayList();
        }
        if (!this.menuItems.contains(menuItem)) {
            this.menuItems.add(menuItem);
        }
    }

    public void addChild(MenuGroupVO childOfCurrentMenuGroup) {
        if (this.children == null) {
            this.children = Sets.newHashSet();
        }
        this.children.add(childOfCurrentMenuGroup);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Collection<MenuItemVO> getMenuItems() {
        return this.menuItems;
    }

    public void setMenuItems(Collection<MenuItemVO> menuItems) {
        this.menuItems = menuItems;
    }

    public Collection<MenuGroupVO> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<MenuGroupVO> children) {
        this.children = children;
    }

    public MenuGroupVO getParent() {
        return this.parent;
    }

    public void setParent(MenuGroupVO parent) {
        this.parent = parent;
    }

    @Override
    public CommonStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(CommonStatus status) {
        this.status = status;
    }

    public Map<String, Collection<MenuItemVO>> getMenuItemByType() {
        return this.menuItemByType;
    }

    public void setMenuItemByType(Map<String, Collection<MenuItemVO>> menuItemByType) {
        this.menuItemByType = menuItemByType;
    }

    public void updateMenuItemByType(MenuItemVO menuItem) {
        ArrayList menuItemVOS;
        String typeName;
        if (this.menuItemByType == null) {
            this.menuItemByType = new LinkedHashMap<String, Collection<MenuItemVO>>();
        }
        if (StringUtils.isEmpty((CharSequence)(typeName = menuItem.getTypeName()))) {
            typeName = "";
        }
        if ((menuItemVOS = this.menuItemByType.get(typeName)) == null) {
            menuItemVOS = Lists.newArrayList();
        }
        menuItemVOS.add(menuItem);
        this.menuItemByType.put(typeName, menuItemVOS);
    }
}

