/*
 * Decompiled with CFR 0.152.
 */
package com.biz.purchase.utils;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);

    public static String Signing(Map<String, String> params, String body, String secret) throws Exception {
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(secret);
        for (Object key : keys) {
            String value = params.get(key);
            if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)value)) continue;
            strBuilder.append((String)key).append(value);
        }
        if (body != null) {
            strBuilder.append(body);
        }
        strBuilder.append(secret);
        byte[] bytes = SignUtil.encryptMD5(strBuilder.toString());
        return SignUtil.byte2hex(bytes);
    }

    private static byte[] encryptMD5(String data) {
        byte[] bytes = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            bytes = md5.digest(data.getBytes(StandardCharsets.UTF_8));
            return bytes;
        }
        catch (GeneralSecurityException gse) {
            log.error(gse.getMessage());
            return bytes;
        }
    }

    public static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }
}

