/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.tms.util;

import com.biz.model.tms.vo.LongitudeAndLatitudeVo;
import com.biz.model.tms.vo.PointVo;
import com.biz.model.tms.vo.StartAndEndPointVo;
import com.biz.model.tms.vo.YingyanHistoryVo;
import com.biz.model.tms.vo.YingyanResVo;
import com.biz.primus.common.utils.JsonUtils;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class YingyanUtil {
    private static final Logger log = LoggerFactory.getLogger(YingyanUtil.class);
    private static final RestTemplate restTemplate = new RestTemplate();
    public static final String addUrl = "http://api.map.baidu.com/trace/v2/entity/add";
    private static final String snAddUrl = "/trace/v2/entity/add?";
    private static final String gethistoryUrl = "http://api.map.baidu.com/trace/v2/track/gethistory?";
    private static final String snGethistoryUrl = "/trace/v2/track/gethistory?";
    private static final String getMapUrl = "http://api.map.baidu.com/staticimage/v2?";
    private static final String ak = "3KFTMsKMowimNgaOupqOolWmFahiCaHl";
    private static final String sk = "BfPRxLng074M3ZwYphGw8CddrDyPHo4w";
    private static final String testServiceId = "156710";
    private static final String proServiceId = "156708";

    public static List<LongitudeAndLatitudeVo> getMapUrl(String entityName, Long startTime, Long endTime, Boolean isPro) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((CharSequence)entityName) || startTime == null || endTime == null) {
            log.info("\u67e5\u8be2\u8f68\u8ff9\u56fe\u7247\u6709\u5f02\u5e38\u53c2\u6570\uff1a{},{},{}", new Object[]{entityName, startTime, endTime});
            return Lists.newArrayList();
        }
        YingyanHistoryVo yingyanHistoryVo = YingyanUtil.getHistory(entityName, startTime, endTime, YingyanUtil.getServiceId(isPro));
        if (yingyanHistoryVo.getStatus() != 0) {
            log.info("\u9e70\u773c\u8fd4\u56de\u9519\u8bef\u63d0\u793astatus:{},msg:{}", (Object)yingyanHistoryVo.getStatus(), (Object)yingyanHistoryVo.getMessage());
            return Lists.newArrayList();
        }
        StartAndEndPointVo startPoint = yingyanHistoryVo.getStart_point();
        StartAndEndPointVo endPointPoint = yingyanHistoryVo.getEnd_point();
        List<PointVo> pointVos = yingyanHistoryVo.getPoints();
        ArrayList longitudeAndLatitudeVos = Lists.newArrayList();
        if (startPoint != null && endPointPoint != null && CollectionUtils.isNotEmpty(pointVos)) {
            LongitudeAndLatitudeVo endLongitudeAndLatitudeVo = new LongitudeAndLatitudeVo();
            endLongitudeAndLatitudeVo.setLongitude(endPointPoint.getLongitude().toString());
            endLongitudeAndLatitudeVo.setLatitude(endPointPoint.getLatitude().toString());
            longitudeAndLatitudeVos.add(endLongitudeAndLatitudeVo);
            for (PointVo pointVo : pointVos) {
                LongitudeAndLatitudeVo longitudeAndLatitudeVo = new LongitudeAndLatitudeVo();
                String[] location = pointVo.getLocation();
                if (location != null && location.length != 0) {
                    for (int i = 0; i < location.length; ++i) {
                        if (i == 0) {
                            longitudeAndLatitudeVo.setLongitude(location[i]);
                            continue;
                        }
                        longitudeAndLatitudeVo.setLatitude(location[i]);
                    }
                }
                longitudeAndLatitudeVos.add(longitudeAndLatitudeVo);
            }
            LongitudeAndLatitudeVo startLongitudeAndLatitudeVo = new LongitudeAndLatitudeVo();
            startLongitudeAndLatitudeVo.setLongitude(startPoint.getLongitude().toString());
            startLongitudeAndLatitudeVo.setLatitude(startPoint.getLatitude().toString());
            longitudeAndLatitudeVos.add(startLongitudeAndLatitudeVo);
            return longitudeAndLatitudeVos;
        }
        return Lists.newArrayList();
    }

    private static YingyanHistoryVo getHistory(String entityName, Long startTime, Long endTime, String serviceId) throws UnsupportedEncodingException {
        startTime = startTime / 1000L;
        endTime = endTime / 1000L;
        String sn = YingyanUtil.getHistorySn(entityName, startTime.toString(), endTime.toString(), serviceId);
        StringBuilder url = new StringBuilder();
        url.append(gethistoryUrl).append("ak=").append(ak).append("&service_id=").append(serviceId).append("&entity_name=").append(entityName).append("&start_time=").append(startTime).append("&end_time=").append(endTime).append("&is_processed=1&transport_mode=2").append("&sn=").append(sn);
        log.info("get\u9e70\u773c\u8f68\u8ff9url:{}", (Object)url.toString());
        String forObject = (String)restTemplate.getForObject(url.toString(), String.class, new Object[0]);
        return (YingyanHistoryVo)JsonUtils.json2Obj((String)forObject, YingyanHistoryVo.class);
    }

    private static String getHistorySn(String entityName, String startTime, String endTime, String serviceId) throws UnsupportedEncodingException {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("ak", ak);
        paramsMap.put("service_id", serviceId);
        paramsMap.put("entity_name", entityName);
        paramsMap.put("start_time", startTime);
        paramsMap.put("end_time", endTime);
        paramsMap.put("is_processed", "1");
        paramsMap.put("transport_mode", "2");
        String paramsStr = YingyanUtil.toQueryString(paramsMap);
        String wholeStr = snGethistoryUrl + paramsStr + sk;
        String tempStr = URLEncoder.encode(wholeStr, "UTF-8");
        String sn = YingyanUtil.MD5(tempStr);
        log.info("\u9e70\u773csn\u7b7e\u540d:{}", (Object)sn);
        return sn;
    }

    public static YingyanResVo addEntityName(String entityName, String serviceId) throws UnsupportedEncodingException {
        log.debug("\u9e70\u773c\u53c2\u6570ak:{},sk:{},serviceId:{},entity_name:{}", new Object[]{ak, sk, serviceId, entityName});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ak", ak);
        map.put("service_id", serviceId);
        map.put("entity_name", entityName);
        map.put("sn", YingyanUtil.getSn(entityName, serviceId));
        String s = (String)restTemplate.postForObject(addUrl, map, String.class, new Object[0]);
        return (YingyanResVo)JsonUtils.json2Obj((String)s, YingyanResVo.class);
    }

    private static String getSn(String entityName, String serviceId) throws UnsupportedEncodingException {
        TreeMap<String, String> paramsMap = new TreeMap<String, String>();
        paramsMap.put("ak", ak);
        paramsMap.put("service_id", serviceId);
        paramsMap.put("entity_name", entityName);
        String paramsStr = YingyanUtil.toQueryString(paramsMap);
        String wholeStr = snAddUrl + paramsStr + sk;
        String tempStr = URLEncoder.encode(wholeStr, "UTF-8");
        String sn = YingyanUtil.MD5(tempStr);
        log.debug("\u9e70\u773csn\u7b7e\u540d:{}", (Object)sn);
        return sn;
    }

    private static String MD5(String md5) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(md5.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static String toQueryString(Map<?, ?> data) throws UnsupportedEncodingException {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<?, ?> pair : data.entrySet()) {
            queryString.append(pair.getKey()).append("=");
            queryString.append(URLEncoder.encode((String)pair.getValue(), "UTF-8")).append("&");
        }
        if (queryString.length() > 0) {
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }

    private static String getServiceId(Boolean isPro) {
        return isPro != false ? proServiceId : testServiceId;
    }
}

