package com.biz.ai.Model;
import java.math.BigDecimal;
import java.util.*;

/**
 * 传入图片的对象
 *
 * @author Keith
 * @version v1.0
 *
 */
public class Picture {


    /**
     * 图片名称
     */
    private String fileName;

    /**
     * 识别酒总数
     */
    private int wineCount;

    /**
     * 识别人总数
     */
    private int personCount;

    /**
     * 识别酒信息
     */
    private List<Wine> wineList;

    /**
     * 识别人信息
     */
    private List<Person> personList;

    public int getWineCount() {
        return wineList!=null?wineList.size():0;
    }

    public void setWineCount(int wineCount) {
        this.wineCount = wineCount;
    }

    public int getPersonCount() {
        return personList!=null?personList.size():0;
    }

    public void setPersonCount(int personCount) {
        this.personCount = personCount;
    }

    public List<Person> getPersonList() {
        return personList;
    }

    public void setPersonList(List<Person> personList) {
        this.personList = personList;
    }

    /**
     * 识别的结果
     * @return 集合数量就代表这张图片包含酒的数量
     */
    public List<Wine> getWineList() {
        return wineList;
    }

    public void setWineList(List<Wine> wineList) {
        this.wineList = wineList;
    }

    /**
     * @return 图片的名称
     */
    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * @return 打印识别结果，重写toString
     */
    public String toWineString() {
        Set<Float> kind = new HashSet<>();
        Map<Float, BigDecimal> winMap = new HashMap<>();
        for (Wine tmp : getWineList()) {
            kind.add(tmp.getKind());
            BigDecimal num = BigDecimal.ZERO;
            if (winMap.get(tmp.getKind()) != null) {
                winMap.put(tmp.getKind(), winMap.get(tmp.getKind()).add(BigDecimal.ONE));
            } else {
                winMap.put(tmp.getKind(), num.add(BigDecimal.ONE));
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("the picture has " + getWineCount() + " wines");

        if(winMap.size()>0) {
            sb.append(", include \n\r");

            for (Float kindSet : winMap.keySet()) {
                String name = "";
                if (kindSet == 1) {
                    name = "sea";
                } else if (kindSet == 2) {
                    name = "sky";
                } else {
                    name = "dream";
                }
                sb.append(name + "-" + winMap.get(kindSet) + "\n\r");
            }
        }

        return sb.toString();
    }
}
