package com.biz.ai.annotation;

import com.biz.ai.config.AIPredictAutoConfig;
import org.springframework.context.annotation.Import;

import java.lang.annotation.*;

/**
 * 启用spring管理 ai识别接口\创建spring bean
 * {@link com.biz.ai.api.PicturePredictInterface}
 * {@link com.biz.ai.core.InceptionPredictClient}
 *
 ##AI接口spring boot启动配置说明

 ####在application.properties配置陈列识别GRPC ip&端口<br>

 grpc.client.aipredict.host[0]=host <br>
 grpc.client.aipredict.port[0]=port <br>

 ####在application.properties配置陈列识别、全景拼接其他属性<br>

 陈列（酒）识别tensorflow 模型名称<br>
 ai.perdict.wineModelName= <br>
 家宴（人）识别tensorflow 模型名称<br>
 ai.perdict.personModelName= <br>
 grpc调用签名<br>
 ai.perdict.signature= <br>
 tensorflow grpc调用超时时间<br>
 ai.perdict.timeout=<br>
 全景拼接stitching.py所在文件夹<br>
 ai.perdict.cmdPath=<br>
 全景拼接stitching.py 文件文件输出路径?(stitching.py文件名称)<br>
 ai.perdict.execFileName=<br>

 * @author bruce.qin
 * @see AIPredictAutoConfig
 * @usage
 * @reviewer
 * @since 2017/11/6
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Import(AIPredictAutoConfig.class)
public @interface EnableAiPredict {

}
