package com.biz.ai.config;

import com.biz.ai.api.PicturePredictInterface;
import com.biz.ai.core.InceptionPredictClient;
import com.biz.ai.core.PicturePredictInterfaceImpl;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.Serializable;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/11/5
 */
@Configuration
@ConfigurationProperties(prefix="ai.perdict")
public class AIPredictAutoConfig implements Serializable{

    private static final long serialVersionUID = 2838734051415315818L;
    /**
     * 全景拼接stitching.py 文件夹
     */
    private String cmdPath;

    /**
     * 全景拼接stitching.py 文件文件输出路径
     */
    private String execFileName;

    /**
     * 陈列（酒）识别tensorflow 模型名称
     */
    private String wineModelName;

    /**
     * 家宴（人）识别tensorflow 模型名称
     */
    private String personModelName;

    /**
     * tensorflow grpc 调用签名
     */
    private String signature;

    /**
     * tensorflow grpc 调用超时时间
     */
    private Long timeout;


    public String getCmdPath() {
        return cmdPath;
    }

    public void setCmdPath(String cmdPath) {
        this.cmdPath = cmdPath;
    }

    public String getExecFileName() {
        return execFileName;
    }

    public void setExecFileName(String execFileName) {
        this.execFileName = execFileName;
    }

    public String getWineModelName() {
        return wineModelName;
    }

    public void setWineModelName(String wineModelName) {
        this.wineModelName = wineModelName;
    }

    public String getPersonModelName() {
        return personModelName;
    }

    public void setPersonModelName(String personModelName) {
        this.personModelName = personModelName;
    }

    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Bean
    public PicturePredictInterface newPicturePredictInterface(AIPredictAutoConfig config,InceptionPredictClient predictClient){
        return new PicturePredictInterfaceImpl(config,predictClient);
    }

    @Bean
    public InceptionPredictClient newInceptionPredictClient(AIPredictAutoConfig config){
        return new InceptionPredictClient(config);
    }

    public Long getTimeout() {
        return timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }
}
