package com.biz.ai.core;

import com.biz.ai.Model.Picture;
import com.biz.ai.api.PicturePredictInterface;
import com.biz.ai.config.AIPredictAutoConfig;
import com.biz.ai.util.Util;
import org.apache.log4j.Logger;

import java.io.File;
import java.util.List;


/**
 * 图片预测接口
 * 检测陈列
 * 检测家宴
 * 全景拼接
 *
 * @author Keith
 * @version v0.0.1
 *          <p>
 *          <p>
 *          <dependency>
 *          <groupId>com.biz.webapi</groupId>
 *          <artifactId>predict-api</artifactId>
 *          <version>0.0.1-bate</version>
 *          </dependency>
 */
public class PicturePredictInterfaceImpl implements PicturePredictInterface {

    private static final Logger logger = Logger.getLogger(PicturePredictInterfaceImpl.class.getName());

    private AIPredictAutoConfig config;

    private InceptionPredictClient inceptionPredictClient;

    public PicturePredictInterfaceImpl() {
    }

    public PicturePredictInterfaceImpl(AIPredictAutoConfig config, InceptionPredictClient inceptionPredictClient) {
        this.config = config;
        this.inceptionPredictClient = inceptionPredictClient;
    }

    //    private final static String host = Util.getSysConfigProperty("host");
//    private final static int port = Integer.valueOf(Util.getSysConfigProperty("port")).intValue();
//    private final static long timeout = Long.valueOf(Util.getSysConfigProperty("timeout")).longValue();
//    private final static String modelName = Util.getSysConfigProperty("model");
//    private final static String signature = Util.getSysConfigProperty("signature");


    @Override
    public Picture display(String imgPath) {
        logger.info("start to process");
        Picture picture = null;
        try {
            if (imgPath != null && imgPath.length() > 0) {
                picture = inceptionPredictClient.do_predict(config.getWineModelName(), config.getSignature(), imgPath);
            } else {
                throw new Exception("image path canot be null");
            }
        } catch (Exception e) {
            logger.warn(e);
        } /*finally {
            try {
                inceptionPredictClient.shutdown();
            } catch (Exception e) {
                logger.warn(e);
            }
        }*/

        logger.info("process finished");
        return picture;
    }

    @Override
    public void fullPicture(/*String cmdPath, String execFileName,*/ String inputPath, String outputPath, String fileName, int asynch) {
        try {
            File file = new File(config.getCmdPath() + config.getExecFileName());
            if (file.exists()) {
                if (fileName == null || fileName.length() == 0) {
                    fileName = "''";
                }
                String cmd = "python3 " + config.getCmdPath() + config.getExecFileName() + " " + inputPath + " " + outputPath + " " + fileName + " " + asynch;
                logger.info("process:" + cmd);
                List<String> result = Util.runShell(cmd);
                for (String s : result) {
                    System.out.println(s);
                }
            } else {
                logger.info("cmd not found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Picture table(String imgPath) {
        logger.info("start to process");
        Picture picture = null;
        try {
            if (imgPath != null && imgPath.length() > 0) {
                picture = inceptionPredictClient.do_person(config.getPersonModelName(),  config.getSignature(), imgPath);
            } else {
                throw new Exception("image path canot be null");
            }
        } catch (Exception e) {
            logger.warn(e);
        } /*finally {
            try {
                inceptionPredictClient.shutdown();
            } catch (Exception e) {
                logger.warn(e);
            }
        }*/
        logger.info("process finished");
        return picture;
    }


    public void setConfig(AIPredictAutoConfig config) {
        this.config = config;
    }

    public void setInceptionPredictClient(InceptionPredictClient inceptionPredictClient) {
        this.inceptionPredictClient = inceptionPredictClient;
    }
}
