package com.biz.ai.util;

import com.biz.ai.Model.DisplayItem;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.math.BigDecimal;
import java.util.*;
import java.util.List;

/**
 * @author Keith
 * @version v1.0
 * @Title: 简述
 * @Description: 描述
 * @date 2017/9/19
 */
public class Util {



    static Map<Float, Color> colorMap = new HashMap();

    static {
        colorMap.put(1f, new Color(255, 51, 51));
        colorMap.put(2f, new Color(240, 255, 51));
        colorMap.put(3f, new Color(51, 255, 51));
        colorMap.put(4f, new Color(51, 51, 255));
        colorMap.put(5f, new Color(185, 51, 255));
        colorMap.put(6f, new Color(145, 247, 255));
        colorMap.put(7f, new Color(254, 192, 0));
        colorMap.put(8f, new Color(83, 129, 53));
        colorMap.put(9f, new Color(0, 176, 240));
        colorMap.put(10f, new Color(240, 255, 51));
        colorMap.put(11f, new Color(145, 247, 255));
    }

    public static final String getSysConfigProperty(String propertyName) {
        String value = null;
        ResourceBundle rb = ResourceBundle.getBundle("predict");
        if(rb.containsKey(propertyName)) {
            value = rb.getString(propertyName);
        }

        return value;
    }


    /**
     * 执行python文件
     * 需要python3环境
     * @param shStr 命令行
     * @return
     * @throws Exception
     */
    public static List<String> runShell(String shStr) throws Exception {
        List<String> strList = new ArrayList<String>();

        Process process;
        process = Runtime.getRuntime().exec(shStr);
        InputStreamReader ir = new InputStreamReader(process
                .getInputStream());
        LineNumberReader input = new LineNumberReader(ir);
        String line;
        process.waitFor();
        while ((line = input.readLine()) != null) {
            strList.add(line);
        }

        return strList;
    }



    /**
     * 在图片上标注
     *
     * @param path
     * @param fileName
     * @param extend
     */
    public static void label(String path, String fileName, String extend, List<DisplayItem> point) {
        try {
            BufferedImage image = ImageIO.read(new File(path + File.separator + fileName + "." + extend));
            Graphics g = image.getGraphics();


            Graphics2D g2d = (Graphics2D) g;

            g2d.setStroke(new BasicStroke(10f));

            //图片实际宽度
            int width = image.getWidth();

            //图片实际高度
            int height = image.getHeight();


            for (int i = 0; i < point.size(); i++) {

                DisplayItem item = point.get(i);
                g2d.setColor(colorMap.get(item.getKind()));//画笔颜色
                Float x1_scale = item.getY1();
                Float x2_scale = item.getY2();
                Float y1_scale = item.getX1();
                Float y2_scale = item.getX2();

                float x1 = width * x1_scale;
                float x2 = width * x2_scale;
                float y1 = height * y1_scale;
                float y2 = height * y2_scale;

                float shapeWidth = x2 - x1;
                float shapeHeight = y2 - y1;
                int _shapeWidth = new BigDecimal(shapeWidth).setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
                int _shapeHeight = new BigDecimal(shapeHeight).setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
                int _x1 = new BigDecimal(x1).setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
                int _y1 = new BigDecimal(y1).setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
                g2d.drawRect(_x1, _y1, _shapeWidth, _shapeHeight);//矩形框(原点x坐标，原点y坐标，矩形的长，矩形的宽)
            }

            FileOutputStream out = new FileOutputStream(path + File.separator + fileName + "_laber." + extend);//输出图片的地址
            ImageIO.write(image, "jpeg", out);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    /**
     * 获取文件名，不包含扩展名
     *
     * @param fileName 文件名称，包含扩展名
     * @return
     */
    public static String getFileName(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    /**
     * 获取文件的扩展名
     *
     * @param fileName 文件名称，包含扩展名
     * @return
     */
    public static String getFileExt(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }
}
