# -*- coding: utf-8 -*-
import os
import cv2
import time
import sys


def write_log(f,log_str):
    f.write(log_str)
    
def getFileName(path,str1):
    uselist=[]
    ''' 获取指定目录下的所有指定后缀的文件名 '''

    f_list = os.listdir(path)
    for i in f_list:
        if os.path.splitext(i)[1] == str1:
            uselist.append(i)
    return uselist

def pinjie(imagelist,str2,str3, vedio_name):
    #print (vedio_name)
    objectlist=[]
    for i in imagelist:
        name = "%s/%s"%(str3, i)
        #print(name)
        a=cv2.imread(name)
        objectlist.append(a)
    stitcher = cv2.createStitcher(False)
    objecttuple=tuple(objectlist)
    result = stitcher.stitch(objecttuple)
    if result[0] !=0:
        return -1
    cv2.imwrite("%s/%s.jpg"%(str3,vedio_name.split('.')[0]), result[1])
    return 0

def procc_vedio(f,list_mp4, input_path, output_path):
    count=0
    for name in list_mp4:
        count+=1
        #print (output_path)
        data = "ffmpeg -i "+"%s/%s"%(input_path,name)+" -r 1 -f image2 "+"%s/%s"%(output_path,"image%d.png")
        #print(data)
        ret = os.system(data)
        #print(ret)
        list_image=getFileName(output_path,'.png')
        #print(len(list_image))
        if pinjie(list_image,input_path,output_path,name) == -1:
            for i in list_image:
                name1 = "%s/%s" % (output_path, i)
                os.remove(name1)
                if f != None:
                    log_str = "%s  -1\n"%(name)
                    f.write(log_str)
                    if count%10 == 0:
                        f.flush()
                else:
                    return -1
        else:
             for i in list_image:
                 name1 = "%s/%s"%(output_path,i)
                 os.remove(name1)
             if f != None:
                 log_str = "%s  0\n"%(name)
                 f.write(log_str)
                 if count%10 == 0:
                     f.flush()
             else:
                 return 0
    return 0
    
def panoramic_stitch(input_path, output_path, vedio_name = None, asunch=1):
     #print (os.path.exists(input_path))
     #print (os.path.exists(output_path))
     if not os.path.exists(input_path) or not os.path.exists(output_path)  :
         print(-2)
         return -2
     list_mp4 = []
     if vedio_name==" " or vedio_name=="":
         list_mp4=getFileName(input_path,'.mp4')
         if len(list_mp4) == 0:
            print(-3)
            return -3
     else:   
         if vedio_name.split('.')[-1] == ".mp4" or vedio_name.split('.')[-1] == ".MP4":
            print(-3)
            return -3
         list_mp4.append("%s"%(vedio_name))
     if asunch == 0:
          #print("asunch")
          ret = procc_vedio(None,list_mp4,input_path, output_path)
          print(ret)
          return 0
     else:
         print(0)
         log_name = "%s/log_%s.txt"%(output_path, time.strftime("%Y%m%d%H%M",time.localtime()))
         f=open(log_name,"w+")
         if f==None:
             print(-4)
             return -4
         write_log(f,"start\n")
         procc_vedio(f,list_mp4,input_path, output_path)
         write_log(f,"end\n")
         f.close()

if __name__ == '__main__':
        panoramic_stitch(sys.argv[1], sys.argv[2], sys.argv[3],sys.argv[4])
        
'''
if __name__ == '__main__':
    start=time.time()
    getpath = '/wwwroot/gongyan/pinjie/'
    savepath= '/wwwroot/gongyan/pinjie/1/'
    list_mp4=getFileName(getpath,'.mp4')
    for name in list_mp4:
        os.system('ffmpeg -i '+getpath+name+' -r 1 -f image2 '+savepath+'image%d.jpg')
        list_image=getFileName(savepath,'.jpg')
        pinjie(list_image,name,savepath)
        for i in list_image:
            os.remove(savepath+i)
    end=time.time()
    print ('time:',end-start)
'''
        
    
    
