package com.biz.ai.api;

import com.biz.ai.Model.Picture;

/**
 * @author Keith
 * @version v1.0
 * @Title: 图片预测
 * @Description: 用来预测陈列，家宴和生成全景图
 * @date 2017/9/21
 */
public interface PicturePredictInterface {

    /**
     * 识别陈列中酒的类型和位置
     * 单张图片处理
     * @param imgPath 本地图片路径
     * @return
     */
    public Picture display(String imgPath);


    /**
     * 视频转全景图
     * @param cmdPath .py所在路径
     * @param execFileName 命令的名 默认为 stitching.py
     * @param inputPath 输入视频的绝对路径
     * @param outputPath 输出全景图片的绝对路径
     * @param fileName 视频名称，带后缀。输入单个视频时，配置为视频文件名，批量为NULL
     * @param asynch 0：阻塞 1：非阻塞
                        0：阻塞，输入视频文件。 等待合成全景图。
                        1：非阻塞， 输入视频文件后，无返回
     */
    public void fullPicture(String cmdPath, String execFileName, String inputPath, String outputPath, String fileName, int asynch);


    /**
     * 识别家宴
     * 桌子的数量，人数，桌子上的酒的种类和数量
     * 单张图片处理
     * @param imgPath 本地图片路径
     * @return
     */
    public Picture table(String imgPath);
}
