package com.biz.ai.core;

import com.biz.ai.Model.Picture;
import com.biz.ai.api.PicturePredictInterface;
import com.biz.ai.util.Util;
import org.apache.log4j.Logger;

import java.io.File;
import java.util.List;


/**
 * 图片预测接口
 * 检测陈列
 * 检测家宴
 * 全景拼接
 *
 * @author Keith
 * @version v0.0.1
 *          <p>
 *          <p>
 *          <dependency>
 *          <groupId>com.biz.webapi</groupId>
 *          <artifactId>predict-api</artifactId>
 *          <version>0.0.1-bate</version>
 *          </dependency>
 */
public class PicturePredictInterfaceImpl implements PicturePredictInterface {

    private final int port;
    private final long timeout;
    private String host;
    private String modelName;
    private String signature;


    public PicturePredictInterfaceImpl(String host, int port, long timeout, String modelName, String signature) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.modelName = modelName;
        this.signature = signature;
    }

//    private final static String host = Util.getSysConfigProperty("host");
//    private final static int port = Integer.valueOf(Util.getSysConfigProperty("port")).intValue();
//    private final static long timeout = Long.valueOf(Util.getSysConfigProperty("timeout")).longValue();
//    private final static String modelName = Util.getSysConfigProperty("model");
//    private final static String signature = Util.getSysConfigProperty("signature");


    private static final Logger logger = Logger.getLogger(PicturePredictInterfaceImpl.class.getName());


    @Override
    public Picture display(String imgPath) {
        logger.info("start to process");
        Picture picture = null;
        InceptionPredictClient client = new InceptionPredictClient(host, port, timeout);
        try {
            if (imgPath != null && imgPath.length() > 0) {
                picture = client.do_predict(modelName, signature, imgPath);
            } else {
                throw new Exception("image path canot be null");
            }
        } catch (Exception e) {
            logger.warn(e);
        } finally {
            try {
                client.shutdown();
            } catch (Exception e) {
                logger.warn(e);
            }
        }

        logger.info("process finished");
        return picture;
    }

    @Override
    public void fullPicture(String cmdPath, String execFileName, String inputPath, String outputPath, String fileName, int asynch) {
        try {
            File file = new File(cmdPath + execFileName);
            if (file.exists()) {
                if (fileName == null || fileName.length() == 0) {
                    fileName = "''";
                }
                String cmd = "python3 " + cmdPath + execFileName + " " + inputPath + " " + outputPath + " " + fileName + " " + asynch;
                logger.info("process:" + cmd);
                List<String> result = Util.runShell(cmd);
                for (String s : result) {
                    System.out.println(s);
                }
            } else {
                logger.info("cmd not found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Picture table(String imgPath) {
        return null;
    }
}
