/*
 * Decompiled with CFR 0.152.
 */
package com.biz.core.spring.event;

import com.biz.core.spring.event.BizEventWrapper;
import com.biz.core.spring.event.SyncBizEventWrapper;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public class BizEventMulticaster
extends SimpleApplicationEventMulticaster {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public BizEventMulticaster() {
        this.setTaskExecutor(Executors.newSingleThreadExecutor());
        this.setErrorHandler(new EventLoggingErrorHandler());
    }

    public void multicastEvent(ApplicationEvent event) {
        this.multicastEvent(event, this.resolveDefaultEventType(event));
    }

    public void multicastEvent(ApplicationEvent event, ResolvableType eventType) {
        ResolvableType type;
        Executor executor = this.getTaskExecutor();
        boolean isAsyncEvent = this.isAsyncEvent(event);
        final ApplicationEvent sourceEvent = this.findSourceEvent(event);
        ResolvableType resolvableType = type = eventType != null ? eventType : this.resolveDefaultEventType(sourceEvent);
        if (this.logger.isDebugEnabled()) {
            // empty if block
        }
        for (final ApplicationListener listener : this.getApplicationListeners(sourceEvent, type)) {
            if (isAsyncEvent) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        BizEventMulticaster.this.invokeListener(listener, sourceEvent);
                    }
                });
                continue;
            }
            this.invokeListener(listener, sourceEvent);
        }
    }

    private ApplicationEvent findSourceEvent(ApplicationEvent event) {
        return event instanceof BizEventWrapper ? ((BizEventWrapper)event).getEvent() : event;
    }

    protected boolean isAsyncEvent(ApplicationEvent event) {
        return !(event instanceof SyncBizEventWrapper);
    }

    private ResolvableType resolveDefaultEventType(ApplicationEvent event) {
        return ResolvableType.forInstance((Object)event);
    }

    protected Executor getTaskExecutor() {
        Executor executor = super.getTaskExecutor();
        Assert.notNull((Object)executor, (String)"multicaster's executor cannot be null,don't tucao my english");
        return executor;
    }

    static class EventLoggingErrorHandler
    implements ErrorHandler {
        private Logger logger = LoggerFactory.getLogger(this.getClass());

        EventLoggingErrorHandler() {
        }

        public void handleError(Throwable t) {
            t.printStackTrace();
            this.logger.error("\u4e8b\u4ef6\u8c03\u7528\u51fa\u9519,message={},ex={}", (Object)t.getMessage(), (Object)t);
        }
    }
}

