/*
 * Decompiled with CFR 0.152.
 */
package com.biz.core.spring.jpatranaction;

import com.biz.core.asserts.SystemAsserts;
import com.biz.core.spring.event.BizEvent;
import com.biz.core.spring.event.BizEventPublisher;
import com.biz.core.utils.ExecutionUnit;
import com.biz.core.utils.Timers;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class BizTranactionManager
extends JpaTransactionManager {
    private static final long serialVersionUID = -4124357045575124417L;
    private static Logger logger = LoggerFactory.getLogger(BizTranactionManager.class);
    private static BizEventPublisher eventPublisher;
    private static final ThreadLocal<List<BizEvent>> asyncEvents;
    private static final ThreadLocal<List<BizEvent>> syncEvents;
    private static final ThreadLocal<List<ExecutionUnit>> preCommitOperate;
    private static final ThreadLocal<List<ExecutionUnit>> redisOperate;
    private static final ThreadLocal<Boolean> inTransactions;

    public void setEventPublisher(BizEventPublisher eventPublisher) {
        BizTranactionManager.eventPublisher = eventPublisher;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        super.doBegin(transaction, definition);
        inTransactions.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit(DefaultTransactionStatus status) {
        Timers timers = Timers.createAndBegin(logger.isDebugEnabled());
        this.executeOpt(preCommitOperate);
        timers.record("preCommitOperate");
        super.doCommit(status);
        timers.record("transactionCommit");
        try {
            this.doPostCommit();
        }
        catch (Throwable e) {
            logger.error("post transaction execute error", e);
            e.printStackTrace();
        }
        finally {
            this.clearThreadLocal();
        }
        timers.record("postCommit");
        timers.print("use time tx-commit");
    }

    private void doPostCommit() {
        this.executeOpt(redisOperate);
        this.publish(syncEvents, false);
        this.publish(asyncEvents, true);
        inTransactions.set(false);
    }

    private void executeOpt(ThreadLocal<List<ExecutionUnit>> unitThreadlocal) {
        List<ExecutionUnit> redisExecutionList = unitThreadlocal.get();
        if (redisExecutionList != null) {
            Timers timers = Timers.createAndBegin(logger.isDebugEnabled());
            for (ExecutionUnit unit : redisExecutionList) {
                unit.execute();
                timers.record(unit.getClass().toString());
            }
            timers.print("use time post-redis-opt[size=" + redisExecutionList.size() + "]");
        }
    }

    private void clearThreadLocal() {
        this.clearList(syncEvents.get());
        this.clearList(asyncEvents.get());
        this.clearList(redisOperate.get());
        this.clearList(preCommitOperate.get());
        inTransactions.set(false);
    }

    private void clearList(List<?> list) {
        if (list != null) {
            list.clear();
        }
    }

    private void publish(ThreadLocal<List<BizEvent>> events, boolean asyncPublish) {
        List<BizEvent> list = events.get();
        if (list != null && !list.isEmpty()) {
            boolean isDebugEnabled = logger.isDebugEnabled();
            for (BizEvent event : list) {
                if (isDebugEnabled) {
                    logger.debug("applicationEventPublisher.publishEvent {}, hashcode {},ts {}", new Object[]{((Object)((Object)event)).getClass().getCanonicalName(), ((Object)((Object)event)).hashCode(), event.getTimestamp()});
                }
                if (asyncPublish) {
                    eventPublisher.publishEvent(event);
                    continue;
                }
                eventPublisher.syncPublishEvent(event);
            }
            list.clear();
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        super.doRollback(status);
        if (logger.isDebugEnabled()) {
            logger.debug("rooback && clear event");
        }
        this.clearThreadLocal();
    }

    public static void publishEvent(BizEvent event, boolean asyncPublish) {
        ThreadLocal<List<BizEvent>> events;
        SystemAsserts.notNull(eventPublisher, "\u4e8b\u52a1\u7ba1\u7406\u5668\u5fc5\u987b\u6ce8\u5165eventPublisher\u624d\u80fd\u8fdb\u884c\u4e8b\u4ef6\u53d1\u5e03", new Object[0]);
        Boolean transFlag = inTransactions.get();
        ThreadLocal<List<BizEvent>> threadLocal = events = asyncPublish ? asyncEvents : syncEvents;
        if (transFlag != null && transFlag.booleanValue()) {
            List<BizEvent> list = events.get();
            if (list == null) {
                list = new ArrayList<BizEvent>();
                events.set(list);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("thread is in Transcation send push envet to list");
            }
            list.add(event);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("thread is not in Transcation send event now! eventPublisher is : {} event is:{} ", (Object)eventPublisher, (Object)event);
            }
            eventPublisher.publishEvent(event);
        }
    }

    public static void delayExecuteIfInTx(ExecutionUnit unit) {
        List<ExecutionUnit> list;
        Boolean transFlag = inTransactions.get();
        if (transFlag != null && transFlag.booleanValue()) {
            list = redisOperate.get();
            if (list == null) {
                list = new ArrayList<ExecutionUnit>(4);
                redisOperate.set(list);
            }
        } else {
            throw new UnsupportedOperationException("redis\u540e\u7f6e\u64cd\u4f5c\u5fc5\u987b\u5728\u4e8b\u52a1\u4e2d\u6267\u884c");
        }
        list.add(unit);
    }

    public static void preCommitOpt(ExecutionUnit unit) {
        Boolean transFlag = inTransactions.get();
        if (transFlag != null && transFlag.booleanValue()) {
            List<ExecutionUnit> list = preCommitOperate.get();
            if (list == null) {
                list = new ArrayList<ExecutionUnit>(4);
                preCommitOperate.set(list);
            }
            list.add(unit);
        } else {
            unit.execute();
        }
    }

    public static void setInTransaction(boolean intx) {
        inTransactions.set(intx);
    }

    static {
        asyncEvents = new ThreadLocal();
        syncEvents = new ThreadLocal();
        preCommitOperate = new ThreadLocal();
        redisOperate = new ThreadLocal();
        inTransactions = new ThreadLocal();
    }
}

