/*
 * Decompiled with CFR 0.152.
 */
package com.biz.core.zookeeper;

import com.biz.core.exception.SystemException;
import com.biz.core.zookeeper.ZkProperties;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Map<String, PropertiesConfiguration> propertyConfigMap = new HashMap<String, PropertiesConfiguration>();
    private static final Logger logger = LoggerFactory.getLogger(ConfigUtils.class);

    private ConfigUtils() {
    }

    private static PropertiesConfiguration getConfig(String propertyFileName) {
        PropertiesConfiguration config = propertyConfigMap.get(propertyFileName);
        if (config == null) {
            try {
                config = new PropertiesConfiguration(propertyFileName);
                logger.debug("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u6210\u529f");
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("\u52a0\u8f7d\u914d\u7f6e" + propertyFileName + "\u51fa\u9519", e);
            }
            propertyConfigMap.put(propertyFileName, config);
        }
        return config;
    }

    public static String getString(String propertyFileName, String propertyName) {
        return ConfigUtils.getConfig(propertyFileName).getString(propertyName);
    }

    public static boolean isConfiguredByZoo() {
        return ConfigUtils.getZookeeperUrl() != null;
    }

    public static String getZookeeperUrl() {
        return System.getProperty("zookeeper.url");
    }

    public static Properties loadFromFileOrZooKeeper(String zooPath, String classPath) {
        Object zkProperties;
        Properties conf = new Properties();
        InputStream inputStream = null;
        try {
            if (ConfigUtils.isConfiguredByZoo() && StringUtils.isNotBlank((CharSequence)zooPath)) {
                zkProperties = new ZkProperties(zooPath);
                inputStream = new ByteArrayInputStream(((ZkProperties)zkProperties).getPropertiesBytes());
            } else {
                inputStream = new FileInputStream(ConfigUtils.class.getResource("/").getPath() + classPath);
            }
            conf.load(new InputStreamReader(inputStream, "UTF-8"));
            zkProperties = conf;
        }
        catch (Exception e) {
            try {
                throw new SystemException("\u8f7d\u914d\u7f6e\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return zkProperties;
    }
}

